/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFBukkitUtil;
import co.aikar.commands.BukkitCommandManager;
import co.aikar.commands.LogLevel;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Locale;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLocaleChangeEvent;

class ACFBukkitLocalesListener
implements Listener {
    private final BukkitCommandManager manager;
    private MethodHandle localeMethod1_8 = null;
    private boolean checkedLocaleMethod1_8 = false;

    ACFBukkitLocalesListener(BukkitCommandManager manager) {
        this.manager = manager;
    }

    @EventHandler
    void onLocaleChange(PlayerLocaleChangeEvent event) {
        if (!this.manager.autoDetectFromClient) {
            return;
        }
        Player player = event.getPlayer();
        Locale locale = null;
        try {
            locale = event.locale();
        }
        catch (NoSuchMethodError ignored) {
            try {
                if (!event.getLocale().equals(this.manager.issuersLocaleString.get(player.getUniqueId()))) {
                    locale = ACFBukkitUtil.stringToLocale(event.getLocale());
                }
            }
            catch (NoSuchMethodError ignored2) {
                try {
                    String value;
                    if (!this.checkedLocaleMethod1_8) {
                        this.checkedLocaleMethod1_8 = true;
                        MethodHandles.Lookup lookup = MethodHandles.lookup();
                        MethodType type = MethodType.methodType(String.class);
                        this.localeMethod1_8 = lookup.findVirtual(PlayerLocaleChangeEvent.class, "getNewLocale", type);
                    }
                    if (this.localeMethod1_8 != null && !(value = this.localeMethod1_8.invoke(event)).equals(this.manager.issuersLocaleString.get(player.getUniqueId()))) {
                        locale = ACFBukkitUtil.stringToLocale(value);
                    }
                }
                catch (Throwable t2) {
                    this.manager.log(LogLevel.ERROR, "Error registering MethodHandle for LocaleChangeEvent", t2);
                }
            }
        }
        if (locale == null) {
            return;
        }
        this.manager.setPlayerLocale(player, locale);
    }
}

