/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.SafeOverrideableArgument;
import dev.jorel.commandapi.exceptions.InvalidRangeException;
import dev.jorel.commandapi.executors.CommandArguments;

public class FloatArgument
extends SafeOverrideableArgument<Float, Float> {
    public FloatArgument(String nodeName) {
        super(nodeName, (ArgumentType<?>)FloatArgumentType.floatArg(), String::valueOf);
    }

    public FloatArgument(String nodeName, float min2) {
        super(nodeName, (ArgumentType<?>)FloatArgumentType.floatArg((float)min2), String::valueOf);
    }

    public FloatArgument(String nodeName, float min2, float max) {
        super(nodeName, (ArgumentType<?>)FloatArgumentType.floatArg((float)min2, (float)max), String::valueOf);
        if (max < min2) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<Float> getPrimitiveType() {
        return Float.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_FLOAT;
    }

    @Override
    public <Source> Float parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return (Float)cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

