/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.SafeOverrideableArgument;
import dev.jorel.commandapi.exceptions.InvalidRangeException;
import dev.jorel.commandapi.executors.CommandArguments;

public class LongArgument
extends SafeOverrideableArgument<Long, Long> {
    public LongArgument(String nodeName) {
        super(nodeName, (ArgumentType<?>)LongArgumentType.longArg(), String::valueOf);
    }

    public LongArgument(String nodeName, long min2) {
        super(nodeName, (ArgumentType<?>)LongArgumentType.longArg((long)min2), String::valueOf);
    }

    public LongArgument(String nodeName, long min2, long max) {
        super(nodeName, (ArgumentType<?>)LongArgumentType.longArg((long)min2, (long)max), String::valueOf);
        if (max < min2) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<Long> getPrimitiveType() {
        return Long.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_LONG;
    }

    @Override
    public <Source> Long parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return (Long)cmdCtx.getArgument(key, this.getPrimitiveType());
    }
}

