/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui;

import dev.triumphteam.gui.GuiView;
import dev.triumphteam.gui.actions.GuiCloseAction;
import dev.triumphteam.gui.click.ClickContext;
import dev.triumphteam.gui.click.MoveResult;
import dev.triumphteam.gui.click.handler.ClickHandler;
import dev.triumphteam.gui.click.processor.ClickProcessor;
import dev.triumphteam.gui.component.GuiComponent;
import dev.triumphteam.gui.component.RenderedComponent;
import dev.triumphteam.gui.component.StatefulGuiComponent;
import dev.triumphteam.gui.component.renderer.GuiComponentRenderer;
import dev.triumphteam.gui.container.type.GuiContainerType;
import dev.triumphteam.gui.element.RenderedGuiElement;
import dev.triumphteam.gui.exception.TriumphGuiException;
import dev.triumphteam.gui.title.GuiTitle;
import dev.triumphteam.gui.title.StatefulGuiTitle;
import dev.triumphteam.gui.title.renderer.DefaultGuiTitleRenderer;
import dev.triumphteam.gui.title.renderer.GuiTitleRenderer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGuiView<P, I>
implements GuiView {
    private final P viewer;
    private final GuiTitle title;
    private final List<GuiComponent<P, I>> components;
    private final List<GuiCloseAction> closeActions;
    private final GuiComponentRenderer<P, I> renderer;
    private final ClickHandler<P> defaultClickHandler;
    private final GuiContainerType containerType;
    private final GuiTitleRenderer titleRenderer = new DefaultGuiTitleRenderer();
    private final ClickProcessor<P, I> clickProcessor;
    private final Map<GuiComponent<P, I>, RenderedComponent<P, I>> renderedComponents = new ConcurrentHashMap<GuiComponent<P, I>, RenderedComponent<P, I>>();
    private final Map<Integer, RenderedGuiElement<P, I>> allRenderedElements = new ConcurrentHashMap<Integer, RenderedGuiElement<P, I>>();
    private boolean updating = false;
    private Component renderedTitle = null;

    public AbstractGuiView(@NotNull P viewer, @NotNull GuiTitle title, @NotNull @NotNull List<@NotNull GuiComponent<P, I>> components, @NotNull List<GuiCloseAction> closeActions, @NotNull GuiContainerType containerType, @NotNull GuiComponentRenderer<P, I> renderer, @NotNull ClickHandler<P> defaultClickHandler, @NotNull ClickProcessor<P, I> clickProcessor) {
        this.title = title;
        this.viewer = viewer;
        this.components = components;
        this.closeActions = closeActions;
        this.containerType = containerType;
        this.renderer = renderer;
        this.defaultClickHandler = defaultClickHandler;
        this.clickProcessor = clickProcessor;
    }

    @NotNull
    public P viewer() {
        return this.viewer;
    }

    @NotNull
    public abstract String viewerName();

    @NotNull
    public abstract UUID viewerUuid();

    protected abstract void clearSlot(int var1);

    protected abstract void populateInventory(@NotNull @NotNull Map<Integer, @NotNull RenderedGuiElement<P, I>> var1);

    protected abstract void openInventory(boolean var1);

    @Override
    public void open() {
        GuiTitle guiTitle = this.title;
        if (guiTitle instanceof StatefulGuiTitle) {
            StatefulGuiTitle statefulGuiTitle = (StatefulGuiTitle)guiTitle;
            statefulGuiTitle.states().forEach(state -> state.addListener(this, () -> this.titleRenderer.renderTitle(this.title, rendered -> {
                this.renderedTitle = rendered;
                this.openInventory(true);
            })));
        }
        this.titleRenderer.renderTitle(this.title, rendered -> {
            this.renderedTitle = rendered;
            this.openInventory(false);
            this.setup();
        });
    }

    protected void setup() {
        this.components.forEach(component -> {
            if (component instanceof StatefulGuiComponent) {
                StatefulGuiComponent statefulComponent = (StatefulGuiComponent)component;
                statefulComponent.states().forEach(state -> state.addListener(this, () -> this.renderer.renderComponent(this.viewer, (GuiComponent<P, I>)component, this)));
            }
            this.renderer.renderComponent(this.viewer, (GuiComponent<P, I>)component, this);
        });
    }

    public void completeRendered(@NotNull RenderedComponent<P, I> renderedComponent) {
        GuiComponent<P, I> ownerComponent = renderedComponent.component();
        RenderedComponent<P, I> existing = this.renderedComponents.get(ownerComponent);
        if (existing != null) {
            existing.renderedItems().forEach((slot, ignored) -> {
                this.clearSlot((int)slot);
                this.allRenderedElements.remove(slot);
            });
        }
        this.renderedComponents.put(ownerComponent, renderedComponent);
        Map<Integer, RenderedGuiElement<P, I>> renderedItems = renderedComponent.renderedItems();
        this.allRenderedElements.putAll(renderedItems);
        this.populateInventory(renderedItems);
    }

    @NotNull
    public MoveResult processClick(@NotNull ClickContext context) {
        return this.clickProcessor.processClick(context, this);
    }

    @Nullable
    public RenderedGuiElement<P, I> getElement(int slot) {
        return this.allRenderedElements.get(slot);
    }

    @NotNull
    public ClickHandler<P> getDefaultClickHandler() {
        return this.defaultClickHandler;
    }

    @NotNull
    public GuiContainerType getContainerType() {
        return this.containerType;
    }

    @NotNull
    public List<GuiCloseAction> getCloseActions() {
        return this.closeActions;
    }

    public Component getTitle() {
        if (this.renderedTitle == null) {
            throw new TriumphGuiException("Tried to get title before it was available.");
        }
        return this.renderedTitle;
    }

    public boolean isUpdating() {
        return this.updating;
    }

    protected void setUpdating(boolean newValue) {
        this.updating = newValue;
    }
}

