/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.builder;

import dev.triumphteam.gui.BaseGui;
import dev.triumphteam.gui.actions.GuiCloseAction;
import dev.triumphteam.gui.click.handler.ClickHandler;
import dev.triumphteam.gui.component.GuiComponent;
import dev.triumphteam.gui.component.SimpleGuiComponent;
import dev.triumphteam.gui.component.functional.FunctionalGuiComponent;
import dev.triumphteam.gui.component.functional.FunctionalGuiComponentRender;
import dev.triumphteam.gui.component.functional.SimpleFunctionalGuiComponent;
import dev.triumphteam.gui.component.renderer.GuiComponentRenderer;
import dev.triumphteam.gui.container.type.GuiContainerType;
import dev.triumphteam.gui.exception.TriumphGuiException;
import dev.triumphteam.gui.settings.GuiSettings;
import dev.triumphteam.gui.title.GuiTitle;
import dev.triumphteam.gui.title.SimpleGuiTitle;
import dev.triumphteam.gui.title.functional.FunctionalGuiTitle;
import dev.triumphteam.gui.title.functional.SimpleFunctionalGuiTitle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class BaseGuiBuilder<B extends BaseGuiBuilder<B, P, G, I, C>, P, G extends BaseGui<P>, I, C extends GuiContainerType> {
    private final GuiSettings<P, I, ?> guiSettings;
    private final List<GuiComponent<P, I>> components = new ArrayList<GuiComponent<P, I>>();
    private final List<GuiCloseAction> closeActions = new ArrayList<GuiCloseAction>();
    private C containerType;
    private ClickHandler<P> clickHandler = null;
    private GuiComponentRenderer<P, I> componentRenderer = null;
    private GuiTitle title = null;
    private long spamPreventionDuration = -1L;

    public BaseGuiBuilder(GuiSettings<P, I, ?> guiSettings, @NotNull C defaultContainerType) {
        this.guiSettings = guiSettings;
        this.containerType = defaultContainerType;
    }

    @Contract(value="_ -> this")
    @NotNull
    public B title(@NotNull GuiTitle title) {
        this.title = title;
        return (B)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public B title(@NotNull Component title) {
        return this.title(new SimpleGuiTitle(() -> title, Collections.emptyList()));
    }

    @NotNull
    public B title(@NotNull @NotNull Consumer<@NotNull FunctionalGuiTitle> title) {
        SimpleFunctionalGuiTitle simpleTitle = new SimpleFunctionalGuiTitle();
        title.accept(simpleTitle);
        return this.title(simpleTitle.asGuiTitle());
    }

    @Contract(value="_ -> this")
    @NotNull
    public B containerType(@NotNull C containerType) {
        this.containerType = containerType;
        return (B)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public B clickHandler(@NotNull ClickHandler<P> clickHandler) {
        this.clickHandler = clickHandler;
        return (B)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public B componentRenderer(@NotNull GuiComponentRenderer<P, I> componentRenderer) {
        this.componentRenderer = componentRenderer;
        return (B)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public B spamPreventionDuration(long spamPreventionDuration) {
        if (spamPreventionDuration < 0L) {
            throw new TriumphGuiException("Spam prevention duration cannot be negative!");
        }
        this.spamPreventionDuration = spamPreventionDuration;
        return (B)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public B component(@NotNull @NotNull Consumer<@NotNull FunctionalGuiComponent<P, I>> component) {
        SimpleFunctionalGuiComponent simpleComponent = new SimpleFunctionalGuiComponent();
        component.accept(simpleComponent);
        this.components.add(simpleComponent.asGuiComponent());
        return (B)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public B statelessComponent(@NotNull FunctionalGuiComponentRender<P, I> render) {
        return this.component(new SimpleGuiComponent<P, I>(render, Collections.emptyList(), this.getClickHandler()));
    }

    @Contract(value="_ -> this")
    @NotNull
    public B component(@NotNull GuiComponent<P, I> component) {
        this.components.add(component);
        return (B)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public B onClose(@NotNull GuiCloseAction closeAction) {
        this.closeActions.add(closeAction);
        return (B)this;
    }

    public abstract G build();

    @NotNull
    protected C getContainerType() {
        return this.containerType;
    }

    @NotNull
    protected List<GuiComponent<P, I>> getComponents() {
        return this.components;
    }

    @NotNull
    protected List<GuiCloseAction> getCloseActions() {
        return this.closeActions;
    }

    @NotNull
    protected ClickHandler<P> getClickHandler() {
        if (this.clickHandler == null) {
            return this.guiSettings.getClickHandler();
        }
        return this.clickHandler;
    }

    @NotNull
    protected GuiComponentRenderer<P, I> getComponentRenderer() {
        if (this.componentRenderer == null) {
            return this.guiSettings.getComponentRenderer();
        }
        return this.componentRenderer;
    }

    @NotNull
    protected GuiTitle getTitle() {
        if (this.title == null) {
            throw new TriumphGuiException("Cannot create GUI with empty title!");
        }
        return this.title;
    }

    protected long getSpamPreventionDuration() {
        if (this.spamPreventionDuration < 0L) {
            return this.guiSettings.getSpamPreventionDuration();
        }
        return this.spamPreventionDuration;
    }
}

