/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.click.handler;

import dev.triumphteam.gui.click.ClickContext;
import dev.triumphteam.gui.click.MoveResult;
import dev.triumphteam.gui.click.action.GuiClickAction;
import dev.triumphteam.gui.click.action.SimpleGuiClickAction;
import dev.triumphteam.gui.click.controller.ClickController;
import dev.triumphteam.gui.click.handler.ClickHandler;
import dev.triumphteam.gui.exception.TriumphGuiException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class CompletableFutureClickHandler<P>
implements ClickHandler<P> {
    private final long timeout;
    private final TimeUnit unit;

    public CompletableFutureClickHandler() {
        this(6L, TimeUnit.SECONDS);
    }

    public CompletableFutureClickHandler(long timeout, @NotNull TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    @NotNull
    public MoveResult handle(@NotNull P player, @NotNull ClickContext context, @NotNull GuiClickAction<P> action, @NotNull ClickController controller) {
        if (!(action instanceof SimpleGuiClickAction)) {
            throw new TriumphGuiException("The click action type '" + action.getClass().getSimpleName() + "' is not supported by the 'CompletableFutureClickHandler'.");
        }
        SimpleGuiClickAction runnableAction = (SimpleGuiClickAction)action;
        controller.completingLater(true);
        CompletableFuture.runAsync(() -> runnableAction.run(player, context)).orTimeout(this.timeout, this.unit).whenComplete((unused, throwable) -> controller.complete((Throwable)throwable));
        return MoveResult.DISALLOW;
    }
}

