/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.click.handler;

import dev.triumphteam.gui.click.ClickContext;
import dev.triumphteam.gui.click.MoveResult;
import dev.triumphteam.gui.click.action.GuiClickAction;
import dev.triumphteam.gui.click.action.MovableGuiClickAction;
import dev.triumphteam.gui.click.action.SimpleGuiClickAction;
import dev.triumphteam.gui.click.controller.ClickController;
import dev.triumphteam.gui.click.handler.ClickHandler;
import dev.triumphteam.gui.exception.TriumphGuiException;
import org.jetbrains.annotations.NotNull;

public final class SimpleClickHandler<P>
implements ClickHandler<P> {
    @Override
    @NotNull
    public MoveResult handle(@NotNull P player, @NotNull ClickContext context, @NotNull GuiClickAction<P> action, @NotNull ClickController controller) {
        if (action instanceof MovableGuiClickAction) {
            MovableGuiClickAction controlGuiClickAction = (MovableGuiClickAction)action;
            return controlGuiClickAction.run(player, context);
        }
        if (!(action instanceof SimpleGuiClickAction)) {
            throw new TriumphGuiException("The click action type '" + action.getClass().getSimpleName() + "' is not supported by the 'SimpleClickHandler'.");
        }
        SimpleGuiClickAction runnableAction = (SimpleGuiClickAction)action;
        runnableAction.run(player, context);
        return MoveResult.DISALLOW;
    }
}

