/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.component.functional;

import dev.triumphteam.gui.click.handler.ClickHandler;
import dev.triumphteam.gui.click.handler.CompletableFutureClickHandler;
import dev.triumphteam.gui.click.handler.SimpleClickHandler;
import dev.triumphteam.gui.component.functional.BaseFunctionalGuiComponent;
import dev.triumphteam.gui.layout.GuiLayout;
import dev.triumphteam.gui.state.pagination.PagerState;
import dev.triumphteam.gui.state.pagination.ScrollerState;
import dev.triumphteam.nova.holder.AbstractStateHolder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFunctionalGuiComponent<P>
extends AbstractStateHolder
implements BaseFunctionalGuiComponent<P> {
    private ClickHandler<P> clickHandler = null;

    @Override
    @NotNull
    public <T> PagerState<T> rememberPager(int startPage, @NotNull List<T> elements, @NotNull GuiLayout layout) {
        return this.remember(PagerState.of(startPage, elements, layout));
    }

    @Override
    @NotNull
    public <T> PagerState<T> rememberPager(@NotNull List<T> elements, @NotNull GuiLayout layout) {
        return this.remember(PagerState.of(elements, layout));
    }

    @Override
    @NotNull
    public <T> ScrollerState<T> rememberScroller(int steps, @NotNull List<T> elements, @NotNull GuiLayout layout) {
        return this.remember(ScrollerState.of(steps, elements, layout));
    }

    @Override
    public void withClickHandler(@Nullable ClickHandler<P> clickHandler) {
        this.clickHandler = clickHandler;
    }

    @Override
    public void withSimpleClickHandler() {
        this.clickHandler = new SimpleClickHandler();
    }

    @Override
    public void withCompletableFutureClickHandler() {
        this.clickHandler = new CompletableFutureClickHandler();
    }

    @Override
    public void withCompletableFutureClickHandler(long timeout, @NotNull TimeUnit unit) {
        this.clickHandler = new CompletableFutureClickHandler(timeout, unit);
    }

    @Nullable
    public ClickHandler<P> getClickHandler() {
        return this.clickHandler;
    }
}

