/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.container;

import dev.triumphteam.gui.click.action.GuiClickAction;
import dev.triumphteam.gui.click.action.SimpleGuiClickAction;
import dev.triumphteam.gui.click.handler.ClickHandler;
import dev.triumphteam.gui.container.GuiContainer;
import dev.triumphteam.gui.container.type.GuiContainerType;
import dev.triumphteam.gui.element.GuiItem;
import dev.triumphteam.gui.element.RenderedClickElement;
import dev.triumphteam.gui.element.RenderedGuiElement;
import dev.triumphteam.gui.element.RenderedGuiItem;
import dev.triumphteam.gui.layout.GuiLayout;
import dev.triumphteam.gui.slot.Slot;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class MapBackedContainer<P, I>
implements GuiContainer<P, I> {
    private final Map<Integer, RenderedGuiElement<P, I>> backing = new HashMap<Integer, RenderedGuiElement<P, I>>(100);
    private final ClickHandler<P> clickHandler;
    private final GuiContainerType containerType;

    public MapBackedContainer(@NotNull ClickHandler<P> clickHandler, @NotNull GuiContainerType containerType) {
        this.clickHandler = clickHandler;
        this.containerType = containerType;
    }

    @Override
    @NotNull
    public GuiContainerType containerType() {
        return this.containerType;
    }

    @Override
    public void setItem(int row, int column, @NotNull @NotNull GuiItem<@NotNull P, @NotNull I> guiItem) {
        this.setItem(this.containerType.toSlot(row, column), guiItem);
    }

    @Override
    public void setItem(@NotNull Slot slot, @NotNull @NotNull GuiItem<@NotNull P, @NotNull I> guiItem) {
        this.setItem(this.containerType.toSlot(slot.row(), slot.column()), guiItem);
    }

    @Override
    public void setItem(int slot, @NotNull @NotNull GuiItem<@NotNull P, @NotNull I> guiItem) {
        this.backing.put(slot, new RenderedGuiItem<P, I>(guiItem.render(), this.clickHandler, guiItem.getClickAction()));
    }

    @Override
    public void setAction(int slot, @NotNull GuiClickAction<P> clickAction) {
        this.backing.put(slot, new RenderedClickElement(this.clickHandler, clickAction));
    }

    @Override
    public void setAction(int row, int column, @NotNull GuiClickAction<P> clickAction) {
        this.setAction(this.containerType.toSlot(row, column), clickAction);
    }

    @Override
    public void setAction(@NotNull Slot slot, @NotNull GuiClickAction<P> clickAction) {
        this.setAction(this.containerType.toSlot(slot.row(), slot.column()), clickAction);
    }

    @Override
    public void setAction(int slot, @NotNull SimpleGuiClickAction<P> clickAction) {
        this.backing.put(slot, new RenderedClickElement(this.clickHandler, clickAction));
    }

    @Override
    public void setAction(int row, int column, @NotNull SimpleGuiClickAction<P> clickAction) {
        this.setAction(this.containerType.toSlot(row, column), clickAction);
    }

    @Override
    public void setAction(@NotNull Slot slot, @NotNull SimpleGuiClickAction<P> clickAction) {
        this.setAction(this.containerType.toSlot(slot.row(), slot.column()), clickAction);
    }

    @Override
    public void fill(@NotNull GuiLayout layout, @NotNull @NotNull GuiItem<@NotNull P, @NotNull I> guiItem) {
        layout.forEach(position -> this.setItem((Slot)position, guiItem));
    }

    @NotNull
    public Map<Integer, RenderedGuiElement<P, I>> complete() {
        return Collections.unmodifiableMap(this.backing);
    }
}

