/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.container.type.types;

import dev.triumphteam.gui.container.type.GuiContainerType;
import dev.triumphteam.gui.slot.Slot;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractChestContainerType
implements GuiContainerType {
    private static final int LOWER_LIMIT = 0;
    private final int rows;
    private final int upperLimit;

    public AbstractChestContainerType(int rows) {
        this.rows = rows;
        this.upperLimit = rows * 9;
    }

    @Override
    public int toSlot(int row, int column) {
        return GuiContainerType.defaultMapping(row, column);
    }

    @Override
    @NotNull
    public Slot toSlot(int slot) {
        return Slot.of(slot / 9 + 1, slot % 9 + 1);
    }

    @Override
    public int toTopInventory(int slot) {
        return slot;
    }

    @Override
    public int toPlayerInventory(int slot) {
        return GuiContainerType.defaultPlayerInventoryMapping(slot - this.upperLimit);
    }

    @Override
    public boolean isPlayerInventory(int slot) {
        return slot > this.upperLimit - 1;
    }

    protected int getUpperLimit() {
        return this.upperLimit;
    }
}

