/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.layout;

import dev.triumphteam.gui.layout.GuiLayout;
import dev.triumphteam.gui.slot.Slot;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public final class BorderGuiLayout
implements GuiLayout {
    private final List<Slot> slots = new ArrayList<Slot>();

    public BorderGuiLayout(int rows) {
        this(Slot.origin(), Slot.max(rows));
    }

    public BorderGuiLayout(@NotNull Slot min2, @NotNull Slot max) {
        IntStream.rangeClosed(min2.column(), max.column()).forEach((int col) -> {
            this.slots.add(Slot.of(min2.row(), col));
            this.slots.add(Slot.of(max.row(), col));
        });
        IntStream.range(min2.row() + 1, max.row()).forEach((int row) -> {
            this.slots.add(Slot.of(row, min2.column()));
            this.slots.add(Slot.of(row, max.column()));
        });
    }

    @Override
    @NotNull
    public Iterator<Slot> iterator() {
        return this.slots.iterator();
    }

    @Override
    public int size() {
        return this.slots.size();
    }
}

