/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.layout;

import dev.triumphteam.gui.layout.GuiLayout;
import dev.triumphteam.gui.slot.Slot;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class BoxGuiLayout
implements GuiLayout {
    private final List<Slot> slots = new ArrayList<Slot>();

    public BoxGuiLayout(@NotNull Slot min2, @NotNull Slot max) {
        this(min2, max, Direction.VERTICAL);
    }

    public BoxGuiLayout(@NotNull Slot min2, @NotNull Slot max, @NotNull Direction direction) {
        switch (direction.ordinal()) {
            case 0: {
                for (int col = min2.column(); col <= max.column(); ++col) {
                    for (int row = min2.row(); row <= max.row(); ++row) {
                        this.slots.add(Slot.of(row, col));
                    }
                }
                break;
            }
            case 1: {
                for (int row = min2.row(); row <= max.row(); ++row) {
                    for (int col = min2.column(); col <= max.column(); ++col) {
                        this.slots.add(Slot.of(row, col));
                    }
                }
                break;
            }
        }
    }

    @Override
    @NotNull
    public Iterator<Slot> iterator() {
        return this.slots.iterator();
    }

    @Override
    public int size() {
        return this.slots.size();
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

