/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.paper;

import dev.triumphteam.gui.BaseGui;
import dev.triumphteam.gui.GuiView;
import dev.triumphteam.gui.actions.GuiCloseAction;
import dev.triumphteam.gui.click.handler.ClickHandler;
import dev.triumphteam.gui.component.GuiComponent;
import dev.triumphteam.gui.component.renderer.GuiComponentRenderer;
import dev.triumphteam.gui.paper.PaperGuiListener;
import dev.triumphteam.gui.paper.PaperGuiSettings;
import dev.triumphteam.gui.paper.PaperGuiView;
import dev.triumphteam.gui.paper.builder.gui.PaperGuiBuilder;
import dev.triumphteam.gui.paper.container.type.PaperContainerType;
import dev.triumphteam.gui.title.GuiTitle;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Gui
implements BaseGui<Player> {
    private static final Plugin plugin = PaperGuiSettings.get().getPlugin();
    private final GuiTitle title;
    private final List<GuiComponent<Player, ItemStack>> components;
    private final List<GuiCloseAction> closeActions;
    private final PaperContainerType containerType;
    private final GuiComponentRenderer<Player, ItemStack> componentRenderer;
    private final ClickHandler<Player> clickHandler;
    private final long spamPreventionDuration;

    public Gui(@NotNull GuiTitle title, @NotNull List<GuiComponent<Player, ItemStack>> components, @NotNull List<GuiCloseAction> closeActions, @NotNull PaperContainerType containerType, @NotNull GuiComponentRenderer<Player, ItemStack> componentRenderer, @NotNull ClickHandler<Player> clickHandler, long spamPreventionDuration) {
        this.title = title;
        this.components = components;
        this.closeActions = closeActions;
        this.containerType = containerType;
        this.componentRenderer = componentRenderer;
        this.clickHandler = clickHandler;
        this.spamPreventionDuration = spamPreventionDuration;
    }

    @Contract(value="_ -> new")
    public static PaperGuiBuilder of(@NotNull PaperContainerType type) {
        return new PaperGuiBuilder(type);
    }

    @Contract(value="_ -> new")
    public static PaperGuiBuilder of(int rows) {
        return new PaperGuiBuilder(PaperContainerType.chest(rows));
    }

    @Contract(value=" -> new")
    public static PaperGuiBuilder hopper() {
        return new PaperGuiBuilder(PaperContainerType.hopper());
    }

    @Override
    @NotNull
    public GuiView open(@NotNull Player player) {
        PaperGuiView view = new PaperGuiView(player, this.title, this.containerType, this.components, this.closeActions, this.componentRenderer, this.clickHandler, this.spamPreventionDuration);
        view.open();
        return view;
    }

    static {
        PaperGuiListener.register(plugin);
    }
}

