/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.paper;

import dev.triumphteam.gui.actions.GuiCloseAction;
import dev.triumphteam.gui.click.ClickContext;
import dev.triumphteam.gui.click.GuiClick;
import dev.triumphteam.gui.click.MoveResult;
import dev.triumphteam.gui.paper.PaperGuiView;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PaperGuiListener
implements Listener {
    public static void register(@NotNull Plugin plugin) {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PaperGuiListener(), plugin);
    }

    @EventHandler
    public void onGuiClick(@NotNull InventoryClickEvent event) {
        PaperGuiView view = this.convertHolder(event.getInventory().getHolder());
        if (view == null) {
            return;
        }
        MoveResult result = view.processClick(new ClickContext(this.mapClick(event.getClick()), event.getRawSlot(), view));
        if (result == MoveResult.DISALLOW) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onGuiDrag(@NotNull InventoryDragEvent event) {
        PaperGuiView view = this.convertHolder(event.getInventory().getHolder());
        if (view == null) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onGuiOpen(@NotNull InventoryOpenEvent event) {
        PaperGuiView view = this.convertHolder(event.getInventory().getHolder());
        if (view == null) {
            return;
        }
        if (!view.isUpdating()) {
            return;
        }
        event.titleOverride(view.getTitle());
    }

    @EventHandler
    public void onGuiClose(@NotNull InventoryCloseEvent event) {
        PaperGuiView view = this.convertHolder(event.getInventory().getHolder());
        if (view == null) {
            return;
        }
        if (view.isUpdating()) {
            return;
        }
        view.getCloseActions().forEach(GuiCloseAction::onClose);
    }

    @Nullable
    private PaperGuiView convertHolder(@Nullable InventoryHolder holder) {
        if (holder == null) {
            return null;
        }
        if (holder instanceof PaperGuiView) {
            PaperGuiView paperGuiView = (PaperGuiView)holder;
            return paperGuiView;
        }
        return null;
    }

    @NotNull
    private GuiClick mapClick(@NotNull ClickType clickType) {
        return switch (clickType) {
            default -> throw new MatchException(null, null);
            case ClickType.LEFT -> GuiClick.LEFT;
            case ClickType.SHIFT_LEFT -> GuiClick.SHIFT_LEFT;
            case ClickType.RIGHT -> GuiClick.RIGHT;
            case ClickType.SHIFT_RIGHT -> GuiClick.SHIFT_RIGHT;
            case ClickType.WINDOW_BORDER_LEFT -> GuiClick.WINDOW_BORDER_LEFT;
            case ClickType.WINDOW_BORDER_RIGHT -> GuiClick.WINDOW_BORDER_RIGHT;
            case ClickType.MIDDLE -> GuiClick.MIDDLE;
            case ClickType.NUMBER_KEY -> GuiClick.NUMBER_KEY;
            case ClickType.DOUBLE_CLICK -> GuiClick.DOUBLE_CLICK;
            case ClickType.DROP -> GuiClick.DROP;
            case ClickType.CONTROL_DROP -> GuiClick.CONTROL_DROP;
            case ClickType.CREATIVE -> GuiClick.CREATIVE;
            case ClickType.SWAP_OFFHAND -> GuiClick.SWAP_OFFHAND;
            case ClickType.UNKNOWN -> GuiClick.UNKNOWN;
        };
    }
}

