/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.paper;

import dev.triumphteam.gui.AbstractGuiView;
import dev.triumphteam.gui.actions.GuiCloseAction;
import dev.triumphteam.gui.click.handler.ClickHandler;
import dev.triumphteam.gui.click.processor.ClickProcessor;
import dev.triumphteam.gui.component.GuiComponent;
import dev.triumphteam.gui.component.renderer.GuiComponentRenderer;
import dev.triumphteam.gui.element.RenderedGuiElement;
import dev.triumphteam.gui.element.RenderedGuiItem;
import dev.triumphteam.gui.exception.TriumphGuiException;
import dev.triumphteam.gui.paper.PaperGuiSettings;
import dev.triumphteam.gui.paper.container.type.PaperContainerType;
import dev.triumphteam.gui.title.GuiTitle;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class PaperGuiView
extends AbstractGuiView<Player, ItemStack>
implements InventoryHolder {
    private final PaperContainerType containerType;
    private final Inventory playerInventory;
    private Inventory inventory = null;

    public PaperGuiView(@NotNull Player player, @NotNull GuiTitle title, @NotNull PaperContainerType containerType, @NotNull List<GuiComponent<Player, ItemStack>> components, @NotNull List<GuiCloseAction> closeActions, @NotNull GuiComponentRenderer<Player, ItemStack> componentRenderer, @NotNull ClickHandler<Player> clickHandler, long spamPreventionDuration) {
        super(player, title, components, closeActions, containerType, componentRenderer, clickHandler, new ClickProcessor(spamPreventionDuration));
        this.containerType = containerType;
        this.playerInventory = player.getInventory();
    }

    @Override
    public void openInventory(boolean updating) {
        if (this.inventory == null) {
            this.inventory = this.containerType.createInventory(this, this.getTitle());
        }
        Player viewer = (Player)this.viewer();
        viewer.getScheduler().run(PaperGuiSettings.get().getPlugin(), task -> {
            if (updating) {
                this.setUpdating(true);
                viewer.openInventory(this.inventory);
                this.setUpdating(false);
                return;
            }
            viewer.openInventory(this.inventory);
        }, null);
    }

    @Override
    public void close() {
        Player viewer = (Player)this.viewer();
        viewer.getScheduler().runDelayed(PaperGuiSettings.get().getPlugin(), task -> viewer.closeInventory(), null, 2L);
    }

    @NotNull
    public Inventory getInventory() {
        this.checkInventory();
        return this.inventory;
    }

    @Override
    protected void clearSlot(int slot) {
        this.checkInventory();
        this.inventory.clear(slot);
    }

    @Override
    @NotNull
    public String viewerName() {
        return ((Player)this.viewer()).getName();
    }

    @Override
    @NotNull
    public UUID viewerUuid() {
        return ((Player)this.viewer()).getUniqueId();
    }

    @Override
    protected void populateInventory(@NotNull Map<Integer, RenderedGuiElement<Player, ItemStack>> renderedItems) {
        renderedItems.forEach((slot, item) -> {
            if (!(item instanceof RenderedGuiItem)) {
                return;
            }
            ItemStack itemStack = (ItemStack)((RenderedGuiItem)item).item();
            if (this.containerType.isPlayerInventory((int)slot)) {
                this.playerInventory.setItem(this.containerType.toPlayerInventory((int)slot), itemStack);
                return;
            }
            this.inventory.setItem(this.containerType.toTopInventory((int)slot), itemStack);
        });
    }

    private void checkInventory() throws TriumphGuiException {
        if (this.inventory == null) {
            throw new TriumphGuiException("Tried to get inventory before it was available.");
        }
    }
}

