/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.paper.builder.item;

import com.google.common.base.Preconditions;
import dev.triumphteam.gui.click.action.EmptyGuiClickAction;
import dev.triumphteam.gui.click.action.GuiClickAction;
import dev.triumphteam.gui.click.action.SimpleGuiClickAction;
import dev.triumphteam.gui.element.GuiItem;
import dev.triumphteam.gui.element.items.SimpleGuiItem;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractItemBuilder<B extends AbstractItemBuilder<B>> {
    private final ItemStack itemStack;
    private ItemMeta meta;

    protected AbstractItemBuilder(@NotNull ItemStack itemStack) {
        Preconditions.checkNotNull(itemStack, "Item can't be null!");
        this.itemStack = itemStack;
        this.meta = itemStack.hasItemMeta() ? itemStack.getItemMeta() : Bukkit.getItemFactory().getItemMeta(itemStack.getType());
    }

    @NotNull
    @Contract(value="_ -> this")
    public B name(@NotNull Component name) {
        if (this.meta == null) {
            return (B)this;
        }
        this.meta.displayName(name);
        return (B)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public B amount(int amount) {
        this.itemStack.setAmount(amount);
        return (B)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public B lore(Component ... lore) {
        return this.lore(Arrays.asList(lore));
    }

    @NotNull
    @Contract(value="_ -> this")
    public B lore(@NotNull List<@Nullable Component> lore) {
        if (this.meta == null) {
            return (B)this;
        }
        this.meta.lore(lore);
        return (B)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public B model(int modelData) {
        if (this.meta == null) {
            return (B)this;
        }
        this.meta.setCustomModelData(Integer.valueOf(modelData));
        return (B)this;
    }

    @NotNull
    @Contract(value=" -> this")
    public B glow() {
        return this.glow(true);
    }

    @NotNull
    @Contract(value="_ -> this")
    public B glow(boolean glow) {
        if (glow) {
            this.meta.addEnchant(Enchantment.LURE, 1, false);
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            return (B)this;
        }
        for (Enchantment enchantment : this.meta.getEnchants().keySet()) {
            this.meta.removeEnchant(enchantment);
        }
        return (B)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public B pdc(@NotNull Consumer<PersistentDataContainer> consumer) {
        consumer.accept(this.meta.getPersistentDataContainer());
        return (B)this;
    }

    @NotNull
    @Contract(value="_, _, _ -> this")
    public B enchant(@NotNull Enchantment enchantment, int level, boolean ignoreLevelRestriction) {
        this.meta.addEnchant(enchantment, level, ignoreLevelRestriction);
        return (B)this;
    }

    @NotNull
    @Contract(value="_, _ -> this")
    public B enchant(@NotNull Enchantment enchantment, int level) {
        return this.enchant(enchantment, level, true);
    }

    @NotNull
    @Contract(value="_ -> this")
    public B enchant(@NotNull Enchantment enchantment) {
        return this.enchant(enchantment, 1, true);
    }

    @NotNull
    @Contract(value="_, _ -> this")
    public B enchant(@NotNull Map<Enchantment, Integer> enchantments, boolean ignoreLevelRestriction) {
        enchantments.forEach((enchantment, level) -> this.enchant((Enchantment)enchantment, (int)level, ignoreLevelRestriction));
        return (B)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public B enchant(@NotNull Map<Enchantment, Integer> enchantments) {
        return this.enchant(enchantments, true);
    }

    @NotNull
    @Contract(value="_ -> this")
    public B disenchant(@NotNull Enchantment enchantment) {
        this.itemStack.removeEnchantment(enchantment);
        return (B)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public B flags(ItemFlag ... flags) {
        this.meta.addItemFlags(flags);
        return (B)this;
    }

    @NotNull
    @Contract(value=" -> this")
    public B unbreakable() {
        return this.unbreakable(true);
    }

    @NotNull
    @Contract(value="_ -> this")
    public B unbreakable(boolean unbreakable) {
        this.meta.setUnbreakable(unbreakable);
        return (B)this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public B meta(ItemMeta meta) {
        this.meta = meta;
        return (B)this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public B meta(@NotNull Consumer<ItemMeta> transform2) {
        transform2.accept(this.meta);
        return (B)this;
    }

    @NotNull
    @Contract(value=" -> new")
    public ItemMeta meta() {
        return this.meta;
    }

    @NotNull
    @Contract(value=" -> new")
    public ItemStack asItemStack() {
        this.itemStack.setItemMeta(this.meta);
        return this.itemStack;
    }

    @NotNull
    @Contract(value="_ -> new")
    public GuiItem<Player, ItemStack> asGuiItem(@NotNull SimpleGuiClickAction<Player> action) {
        return new SimpleGuiItem<Player, ItemStack>(this.asItemStack(), action);
    }

    @NotNull
    @Contract(value="_ -> new")
    public GuiItem<Player, ItemStack> asGuiItem(@NotNull GuiClickAction<Player> action) {
        return new SimpleGuiItem<Player, ItemStack>(this.asItemStack(), action);
    }

    @NotNull
    @Contract(value=" -> new")
    public GuiItem<Player, ItemStack> asGuiItem() {
        return new SimpleGuiItem<Player, ItemStack>(this.asItemStack(), new EmptyGuiClickAction());
    }
}

