/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.paper.builder.item;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import dev.triumphteam.gui.exception.TriumphGuiException;
import dev.triumphteam.gui.paper.builder.item.AbstractItemBuilder;
import dev.triumphteam.gui.paper.util.SkullUtil;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class SkullBuilder
extends AbstractItemBuilder<SkullBuilder> {
    private static final Field PROFILE_FIELD;

    SkullBuilder() {
        super(SkullUtil.skull());
    }

    SkullBuilder(@NotNull ItemStack itemStack) {
        super(itemStack);
        if (!SkullUtil.isPlayerSkull(itemStack)) {
            throw new TriumphGuiException("SkullBuilder requires the material to be a PLAYER_HEAD/SKULL_ITEM!");
        }
    }

    @NotNull
    @Contract(value="_, _ -> this")
    public SkullBuilder texture(@NotNull String texture, @NotNull UUID profileId) {
        if (!SkullUtil.isPlayerSkull(this.asItemStack())) {
            return this;
        }
        int version = Integer.parseInt(Bukkit.getServer().getMinecraftVersion().replace(".", ""));
        if (version >= 1201) {
            String textureUrl = SkullUtil.getSkinUrl(texture);
            if (textureUrl == null) {
                return this;
            }
            SkullMeta skullMeta = (SkullMeta)this.asItemStack().getItemMeta();
            PlayerProfile profile = Bukkit.createPlayerProfile((UUID)profileId, (String)"");
            PlayerTextures textures = profile.getTextures();
            try {
                textures.setSkin(new URL(textureUrl));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return this;
            }
            profile.setTextures(textures);
            skullMeta.setOwnerProfile(profile);
            this.meta((ItemMeta)skullMeta);
            return this;
        }
        if (PROFILE_FIELD == null) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)this.meta();
        GameProfile profile = new GameProfile(profileId, "");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
        try {
            PROFILE_FIELD.set(skullMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        this.meta((ItemMeta)skullMeta);
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public SkullBuilder texture(@NotNull String texture) {
        return this.texture(texture, UUID.randomUUID());
    }

    @NotNull
    @Contract(value="_ -> this")
    public SkullBuilder owner(@NotNull OfflinePlayer player) {
        if (!SkullUtil.isPlayerSkull(this.asItemStack())) {
            return this;
        }
        SkullMeta skullMeta = (SkullMeta)this.meta();
        skullMeta.setOwningPlayer(player);
        this.meta((ItemMeta)skullMeta);
        return this;
    }

    static {
        Field field;
        try {
            SkullMeta skullMeta = (SkullMeta)SkullUtil.skull().getItemMeta();
            field = skullMeta.getClass().getDeclaredField("profile");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            field = null;
        }
        PROFILE_FIELD = field;
    }
}

