/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.gui.state.pagination;

import dev.triumphteam.gui.layout.GuiLayout;
import dev.triumphteam.gui.slot.Slot;
import dev.triumphteam.gui.state.pagination.PageEntry;
import dev.triumphteam.gui.state.pagination.ScrollerState;
import dev.triumphteam.nova.AbstractState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractScrollerState<T>
extends AbstractState
implements ScrollerState<T> {
    private final int steps;
    private final int elementsPerView;
    private final List<T> elements;
    private final GuiLayout layout;
    private final int limit;
    private int current;

    public AbstractScrollerState(int steps, int startPosition, @NotNull List<T> elements, @NotNull GuiLayout layout) {
        this.elementsPerView = layout.size();
        this.steps = steps < 1 ? this.elementsPerView : steps;
        this.current = startPosition;
        this.elements = elements;
        this.layout = layout;
        this.limit = elements.size();
    }

    @Override
    public void next() {
        if (this.current + this.elementsPerView > this.limit) {
            return;
        }
        this.current += this.steps;
        this.trigger();
    }

    @Override
    public void prev() {
        if (this.current <= 1) {
            return;
        }
        this.current -= this.steps;
        this.trigger();
    }

    @Override
    @NotNull
    public Iterator<PageEntry<T>> iterator() {
        int from = this.current - 1;
        int to = Math.min(from + this.elementsPerView, this.elements.size());
        ArrayList<PageEntry<T>> subList = new ArrayList<PageEntry<T>>();
        Iterator layoutIterator = this.layout.iterator();
        for (int i = from; i < to && layoutIterator.hasNext(); ++i) {
            Slot slot = (Slot)layoutIterator.next();
            subList.add(new PageEntry<T>(slot, this.elements.get(i)));
        }
        return subList.iterator();
    }

    protected int getSteps() {
        return this.steps;
    }

    protected int getElementsPerView() {
        return this.elementsPerView;
    }

    protected List<T> getElements() {
        return this.elements;
    }

    protected int getLimit() {
        return this.limit;
    }

    protected int getCurrent() {
        return this.current;
    }
}

