/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.nova;

import dev.triumphteam.nova.AbstractState;
import dev.triumphteam.nova.MutableState;
import dev.triumphteam.nova.policy.StateMutationPolicy;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMutableState<T>
extends AbstractState
implements MutableState<T> {
    private final StateMutationPolicy<T> mutationPolicy;
    private T value;

    public AbstractMutableState(T value, @NotNull StateMutationPolicy<T> mutationPolicy) {
        this.value = value;
        this.mutationPolicy = mutationPolicy;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void set(T value) {
        if (!this.mutationPolicy.shouldMutate(this.value, value)) {
            return;
        }
        this.value = value;
        this.trigger();
    }

    @Override
    public T update(@NotNull Function<T, T> update) {
        T newValue = update.apply(this.value);
        this.set(newValue);
        return this.value;
    }

    @Override
    @NotNull
    public StateMutationPolicy<T> stateMutationPolicy() {
        return this.mutationPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMutableState that = (AbstractMutableState)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return "MutableState{value=" + this.value + ",mutationPolicy=" + this.mutationPolicy + "}";
    }
}

