/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.nova;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.triumphteam.nova.State;
import dev.triumphteam.nova.builtin.SimpleMutableState;
import dev.triumphteam.nova.policy.StateMutationPolicy;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MutableState<T>
extends State {
    @NotNull
    public static <T> @NotNull MutableState<@NotNull T> of(@NotNull T value) {
        return MutableState.of(value, new StateMutationPolicy.StructuralEquality());
    }

    @NotNull
    public static <T> @NotNull MutableState<@NotNull T> of(@NotNull T value, @NotNull StateMutationPolicy<T> policy) {
        return new SimpleMutableState<T>(value, policy);
    }

    public static <T> @NotNull MutableState<@Nullable T> ofNullable() {
        return MutableState.ofNullable(null);
    }

    public static <T> @NotNull MutableState<@Nullable T> ofNullable(@Nullable T value) {
        return MutableState.ofNullable(value, new StateMutationPolicy.StructuralEquality());
    }

    public static <T> @NotNull MutableState<@Nullable T> ofNullable(@Nullable T value, @NotNull StateMutationPolicy<T> policy) {
        return new SimpleMutableState<T>(value, policy);
    }

    public T get();

    public void set(T var1);

    @CanIgnoreReturnValue
    public T update(@NotNull Function<T, T> var1);

    @NotNull
    public StateMutationPolicy<T> stateMutationPolicy();
}

