/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.nova;

import dev.triumphteam.nova.StateCacheFactory;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;

public final class StateListenerContainer {
    private final Map<Object, Queue<Runnable>> listeners = StateCacheFactory.create();

    public void addListener(@NotNull Object stateful, @NotNull Runnable listener) {
        this.listeners.computeIfAbsent(stateful, ignored -> new ConcurrentLinkedQueue()).add(listener);
    }

    public void triggerAll() {
        this.listeners.values().forEach(listeners -> listeners.forEach(Runnable::run));
    }
}

