/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.nova.builtin;

import dev.triumphteam.nova.AbstractState;
import dev.triumphteam.nova.ListState;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;

public final class ListBackedListState<T>
extends AbstractState
implements ListState<T> {
    private final List<T> backing;

    public ListBackedListState(@NotNull List<T> backing) {
        this.backing = backing;
    }

    @Override
    public boolean add(T t2) {
        this.backing.add(t2);
        this.trigger();
        return true;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.backing.remove(o);
        if (removed) {
            this.trigger();
        }
        return removed;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        boolean added = this.backing.addAll(c);
        if (added) {
            this.trigger();
        }
        return added;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> c) {
        boolean added = this.backing.addAll(index, c);
        if (added) {
            this.trigger();
        }
        return added;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        boolean removed = this.backing.removeAll(c);
        if (removed) {
            this.trigger();
        }
        return removed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        boolean retained = this.backing.retainAll(c);
        if (retained) {
            this.trigger();
        }
        return retained;
    }

    @Override
    public T set(int index, T element) {
        T updated = this.backing.set(index, element);
        this.trigger();
        return updated;
    }

    @Override
    public void clear() {
        this.backing.clear();
        this.trigger();
    }

    @Override
    public T remove(int index) {
        T updated = this.backing.remove(index);
        this.trigger();
        return updated;
    }

    @Override
    public void add(int index, T element) {
        this.backing.add(index, element);
        this.trigger();
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.backing.contains(o);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.backing.iterator();
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return this.backing.toArray();
    }

    @Override
    @NotNull
    public <A> @NotNull A @NotNull [] toArray(@NotNull @NotNull A @NotNull [] a) {
        return this.backing.toArray(a);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.backing.containsAll(c);
    }

    @Override
    public T get(int index) {
        return this.backing.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.backing.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.backing.lastIndexOf(o);
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return this.backing.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        return this.backing.listIterator(index);
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        return this.backing.subList(fromIndex, toIndex);
    }
}

