/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.nova.builtin;

import dev.triumphteam.nova.AbstractState;
import dev.triumphteam.nova.MapState;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MapBackedMapState<K, V>
extends AbstractState
implements MapState<K, V> {
    private final Map<K, V> backing;

    public MapBackedMapState(@NotNull Map<K, V> backing) {
        this.backing = backing;
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        V val = this.backing.put(key, value);
        this.trigger();
        return val;
    }

    @Override
    public V remove(Object key) {
        V val = this.backing.remove(key);
        this.trigger();
        return val;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m4) {
        this.backing.putAll(m4);
        this.trigger();
    }

    @Override
    public void clear() {
        this.backing.clear();
        this.trigger();
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backing.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backing.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.backing.get(key);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.backing.keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.backing.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backing.entrySet();
    }
}

