/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.nova.holder;

import dev.triumphteam.nova.ListState;
import dev.triumphteam.nova.MapState;
import dev.triumphteam.nova.MutableState;
import dev.triumphteam.nova.State;
import dev.triumphteam.nova.builtin.EmptyState;
import dev.triumphteam.nova.builtin.SimpleMutableState;
import dev.triumphteam.nova.holder.StateHolder;
import dev.triumphteam.nova.policy.StateMutationPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractStateHolder
implements StateHolder {
    private final List<State> states = new ArrayList<State>();

    @Override
    @NotNull
    public State remember() {
        return this.remember((State)new EmptyState());
    }

    @Override
    @NotNull
    public <S extends State> S remember(@NotNull S state) {
        this.states.add(state);
        return state;
    }

    @Override
    @NotNull
    public <T> @NotNull MutableState<@NotNull T> remember(@NotNull T value) {
        return this.remember(value, new StateMutationPolicy.StructuralEquality());
    }

    @Override
    @NotNull
    public <T> @NotNull MutableState<@NotNull T> remember(@NotNull T value, @NotNull StateMutationPolicy<T> mutationPolicy) {
        return this.remember((State)new SimpleMutableState<T>(value, mutationPolicy));
    }

    @Override
    public <T> @NotNull MutableState<@Nullable T> rememberNullable(@Nullable T value) {
        return this.rememberNullable(value, new StateMutationPolicy.StructuralEquality());
    }

    @Override
    public <T> @NotNull MutableState<@Nullable T> rememberNullable(@Nullable T value, @NotNull StateMutationPolicy<T> mutationPolicy) {
        return this.remember((State)new SimpleMutableState<T>(value, mutationPolicy));
    }

    @Override
    @NotNull
    public <T> List<T> rememberList() {
        return this.remember((State)ListState.of());
    }

    @Override
    @SafeVarargs
    @NotNull
    public final <T> List<T> rememberList(T ... values2) {
        return this.remember((State)ListState.of(values2));
    }

    @Override
    @NotNull
    public <T> List<T> rememberList(@NotNull List<T> backing) {
        return this.remember((State)ListState.of(backing));
    }

    @Override
    @NotNull
    public <K, V> Map<K, V> rememberMap() {
        return this.remember((State)MapState.of());
    }

    @Override
    @NotNull
    public <K, V> Map<K, V> rememberMap(@NotNull Map<K, V> backing) {
        return this.remember((State)MapState.of(backing));
    }

    @NotNull
    protected List<State> getStates() {
        return this.states;
    }
}

