/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.nova.policy;

import org.jetbrains.annotations.Nullable;

public interface StateMutationPolicy<T> {
    public static <T> StateMutationPolicy<T> reference() {
        return new ReferenceEquality();
    }

    public static <T> StateMutationPolicy<T> structural() {
        return new StructuralEquality();
    }

    public static <T> StateMutationPolicy<T> neverEqual() {
        return new NeverEqual();
    }

    public boolean shouldMutate(@Nullable T var1, @Nullable T var2);

    public static final class ReferenceEquality<T>
    implements StateMutationPolicy<T> {
        @Override
        public boolean shouldMutate(@Nullable T currentValue, @Nullable T newValue) {
            return currentValue != newValue;
        }

        public String toString() {
            return "ReferenceEquality";
        }
    }

    public static final class StructuralEquality<T>
    implements StateMutationPolicy<T> {
        @Override
        public boolean shouldMutate(@Nullable T currentValue, @Nullable T newValue) {
            if (currentValue == null || newValue == null) {
                return false;
            }
            return !currentValue.equals(newValue);
        }

        public String toString() {
            return "StructuralEquality";
        }
    }

    public static final class NeverEqual<T>
    implements StateMutationPolicy<T> {
        @Override
        public boolean shouldMutate(@Nullable T currentValue, @Nullable T newValue) {
            return true;
        }

        public String toString() {
            return "NeverEqual";
        }
    }
}

