/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom;

import co.aikar.commands.PaperCommandManager;
import com.github.shynixn.mccoroutine.folia.SuspendingJavaPlugin;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIPaperConfig;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shotrush.atom.commands.Commands;
import org.shotrush.atom.content.mobs.ai.debug.MobAIDebugCommand;
import org.shotrush.atom.content.mobs.ai.debug.VisualDebugger;
import org.shotrush.atom.content.mobs.commands.HerdCommand;
import org.shotrush.atom.content.mobs.herd.HerdManager;
import org.shotrush.atom.content.systems.ItemHeatSystem;
import org.shotrush.atom.content.systems.PlayerTemperatureSystem;
import org.shotrush.atom.content.systems.ThirstSystem;
import org.shotrush.atom.content.workstation.Workstations;
import org.shotrush.atom.core.age.AgeManager;
import org.shotrush.atom.core.api.AtomAPI;
import org.shotrush.atom.core.api.player.PlayerDataAPI;
import org.shotrush.atom.core.blocks.CustomBlockManager;
import org.shotrush.atom.core.items.CustomItemRegistry;
import org.shotrush.atom.core.storage.DataStorage;
import org.shotrush.atom.core.workstations.WorkstationManager;
import org.shotrush.atom.listener.PlayerDataTrackingListener;
import org.shotrush.atom.listener.PlayerMiningListener;
import org.shotrush.atom.listener.RecipeUnlockHandler;
import org.shotrush.atom.listener.TestListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0002R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u0004\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u0004\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0004\u001a\u0004\u0018\u00010\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lorg/shotrush/atom/Atom;", "Lcom/github/shynixn/mccoroutine/folia/SuspendingJavaPlugin;", "<init>", "()V", "value", "Lorg/shotrush/atom/core/blocks/CustomBlockManager;", "blockManager", "getBlockManager", "()Lorg/shotrush/atom/core/blocks/CustomBlockManager;", "Lorg/shotrush/atom/core/items/CustomItemRegistry;", "itemRegistry", "getItemRegistry", "()Lorg/shotrush/atom/core/items/CustomItemRegistry;", "Lorg/shotrush/atom/core/storage/DataStorage;", "dataStorage", "getDataStorage", "()Lorg/shotrush/atom/core/storage/DataStorage;", "Lorg/shotrush/atom/core/age/AgeManager;", "ageManager", "getAgeManager", "()Lorg/shotrush/atom/core/age/AgeManager;", "onLoad", "", "onEnable", "setupCommands", "onDisable", "saveAllPlayerData", "Companion", "Atom"})
public final class Atom
extends SuspendingJavaPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CustomBlockManager blockManager;
    @Nullable
    private CustomItemRegistry itemRegistry;
    @Nullable
    private DataStorage dataStorage;
    @Nullable
    private AgeManager ageManager;
    public static Atom instance;

    @Nullable
    public final CustomBlockManager getBlockManager() {
        return this.blockManager;
    }

    @Nullable
    public final CustomItemRegistry getItemRegistry() {
        return this.itemRegistry;
    }

    @Nullable
    public final DataStorage getDataStorage() {
        return this.dataStorage;
    }

    @Nullable
    public final AgeManager getAgeManager() {
        return this.ageManager;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        CommandAPI.onLoad(new CommandAPIPaperConfig((LifecycleEventOwner)this));
    }

    @Override
    public void onEnable() {
        super.onEnable();
        CommandAPI.onEnable();
        Companion.setInstance(this);
        AtomAPI.initialize(this);
        this.dataStorage = AtomAPI.dataStorage;
        this.ageManager = AtomAPI.ageManager;
        this.itemRegistry = AtomAPI.itemRegistry;
        this.blockManager = AtomAPI.blockManager;
        AtomAPI.registerAges();
        AtomAPI.registerItems();
        AtomAPI.registerBlocks();
        AtomAPI.registerSystems();
        Workstations.INSTANCE.init();
        TestListener.INSTANCE.register(this);
        PlayerDataTrackingListener.INSTANCE.register(this);
        PlayerMiningListener.INSTANCE.register(this);
        RecipeUnlockHandler.INSTANCE.register(this);
        this.setupCommands();
        this.getLogger().info("Atom plugin has been enabled!");
    }

    private final void setupCommands() {
        PaperCommandManager commandManager = new PaperCommandManager(this);
        AtomAPI.registerCommands(commandManager);
        HerdManager herdManager = AtomAPI.Systems.getService("herd_manager", HerdManager.class);
        if (herdManager != null) {
            commandManager.registerCommand(new HerdCommand(herdManager));
            VisualDebugger visualDebugger = new VisualDebugger(this);
            commandManager.registerCommand(new MobAIDebugCommand(visualDebugger, herdManager));
        }
        Commands.INSTANCE.register();
    }

    @Override
    public void onDisable() {
        CommandAPI.onDisable();
        this.saveAllPlayerData();
        if (WorkstationManager.instance != null) {
            WorkstationManager.instance.saveWorkstations();
        }
        AtomAPI.shutdown();
        this.getLogger().info("Atom plugin has been disabled!");
    }

    private final void saveAllPlayerData() {
        this.getLogger().info("Saving all player data...");
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (ThirstSystem.instance != null) {
                int thirst = ThirstSystem.instance.getThirst(player);
                PlayerDataAPI.setInt(player, "thirst.level", thirst);
            }
            if (ItemHeatSystem.instance != null) {
                for (int slot = 0; slot < 9; ++slot) {
                    ItemStack item = player.getInventory().getItem(slot);
                    if (item == null || item.getType() == Material.AIR) continue;
                    ItemHeatSystem.instance.saveHeatForSlot(player, slot, item);
                }
            }
            if (PlayerTemperatureSystem.instance == null) continue;
            double temp = PlayerTemperatureSystem.instance.getPlayerTemperature(player);
            PlayerDataAPI.setDouble(player, "temperature.body", temp);
        }
        this.getLogger().info("Player data saved for " + Bukkit.getOnlinePlayers().size() + " players");
    }

    @NotNull
    public static final Atom getInstance() {
        return Companion.getInstance();
    }

    public static final void setInstance(@NotNull Atom atom) {
        Companion.setInstance(atom);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/shotrush/atom/Atom$Companion;", "", "<init>", "()V", "instance", "Lorg/shotrush/atom/Atom;", "getInstance$annotations", "getInstance", "()Lorg/shotrush/atom/Atom;", "setInstance", "(Lorg/shotrush/atom/Atom;)V", "Atom"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Atom getInstance() {
            Atom atom = instance;
            if (atom != null) {
                return atom;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        public final void setInstance(@NotNull Atom atom) {
            Intrinsics.checkNotNullParameter(atom, "<set-?>");
            instance = atom;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

