/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.commands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Description;
import co.aikar.commands.annotation.Subcommand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.Atom;
import org.shotrush.atom.commands.annotation.AutoRegister;
import org.shotrush.atom.core.age.Age;
import org.shotrush.atom.core.age.AgeManager;

@AutoRegister(priority=50)
@CommandAlias(value="age")
@Description(value="Manage server ages and progression")
public class AgeCommand
extends BaseCommand {
    private final AgeManager ageManager;

    public AgeCommand(Plugin plugin) {
        this.ageManager = ((Atom)plugin).getAgeManager();
    }

    @Default
    @Subcommand(value="info")
    @Description(value="View current age information")
    public void onInfo(Player player) {
        Age current = this.ageManager.getCurrentAge();
        if (current == null) {
            player.sendMessage("\u00a7cNo age is currently set!");
            return;
        }
        player.sendMessage("\u00a76=== The Current Age ===");
        player.sendMessage("\u00a7eAge: \u00a7f" + current.getDisplayName());
        player.sendMessage("\u00a7eYear: \u00a7f" + current.getYearDisplay());
        player.sendMessage("\u00a7eProgress: \u00a7f" + (this.ageManager.getCurrentAgeIndex() + 1) + "/" + this.ageManager.getTotalAges());
        if (current.getDescription() != null) {
            player.sendMessage("\u00a7eDescription: \u00a77" + current.getDescription());
        }
        this.ageManager.getNextAge().ifPresentOrElse(next -> player.sendMessage("\u00a7eNext Age: \u00a7f" + next.getDisplayName() + " \u00a77(" + next.getYearDisplay() + ")"), () -> player.sendMessage("\u00a77This is the final age!"));
    }

    @Subcommand(value="next")
    @Description(value="Progress to the next age")
    @CommandPermission(value="atom.age.progress")
    public void onNext(Player player) {
        if (this.ageManager.progressToNextAge(player)) {
            player.sendMessage("\u00a7aYou have advanced the server to the next age!");
        } else {
            player.sendMessage("\u00a7cCannot progress - already at the final age or event was cancelled!");
        }
    }

    @Subcommand(value="set")
    @Description(value="Set the current age")
    @CommandPermission(value="atom.age.set")
    @CommandCompletion(value="@ages")
    public void onSet(Player player, String ageId) {
        if (this.ageManager.progressToAge(ageId, player)) {
            player.sendMessage("\u00a7aAge changed successfully!");
        } else {
            player.sendMessage("\u00a7cFailed to change age - age not found or event was cancelled!");
        }
    }

    @Subcommand(value="list")
    @Description(value="List all registered ages")
    public void onList(Player player) {
        if (this.ageManager.getTotalAges() == 0) {
            player.sendMessage("\u00a7cNo ages registered!");
            return;
        }
        player.sendMessage("\u00a76=== Registered Ages ===");
        Age current = this.ageManager.getCurrentAge();
        for (Age age : this.ageManager.getAllAges()) {
            String prefix = age.equals(current) ? "\u00a7a\u27a4 " : "\u00a77  ";
            player.sendMessage(prefix + "\u00a7f" + age.getDisplayName() + " \u00a77(" + age.getYearDisplay() + ")");
        }
    }

    @Subcommand(value="broadcast")
    @Description(value="Broadcast the current age to all players")
    @CommandPermission(value="atom.age.broadcast")
    public void onBroadcast(Player player) {
        if (this.ageManager.getCurrentAge() == null) {
            player.sendMessage("\u00a7cNo age is currently set!");
            return;
        }
        this.ageManager.broadcastCurrentAge();
        player.sendMessage("\u00a7aAge broadcasted to all players!");
    }
}

