/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.commands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Description;
import java.util.Collection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.shotrush.atom.Atom;
import org.shotrush.atom.commands.annotation.AutoRegister;
import org.shotrush.atom.core.items.CustomItem;

@AutoRegister(priority=100)
@CommandAlias(value="giveallitems|allitems")
@Description(value="Give all auto-registered custom items")
public class GiveAllItemsCommand
extends BaseCommand {
    @Default
    @CommandPermission(value="atom.giveallitems")
    public void onGiveAllItems(Player player) {
        Collection<CustomItem> items = Atom.getInstance().getItemRegistry().getAllItems();
        if (items.isEmpty()) {
            player.sendMessage("\u00a7cNo custom items registered!");
            return;
        }
        int given = 0;
        for (CustomItem item : items) {
            try {
                ItemStack itemStack = item.create();
                if (itemStack == null) continue;
                player.getInventory().addItem(new ItemStack[]{itemStack});
                ++given;
            }
            catch (Exception e) {
                player.sendMessage("\u00a7cFailed to create item: " + item.getIdentifier());
                e.printStackTrace();
            }
        }
        player.sendMessage("\u00a7aGave you " + given + " custom items!");
    }
}

