/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.commands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Subcommand;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.shotrush.atom.Atom;
import org.shotrush.atom.commands.annotation.AutoRegister;
import org.shotrush.atom.core.skin.SkinAPI;
import org.shotrush.atom.core.util.ActionBarManager;

@AutoRegister(priority=60)
@CommandAlias(value="skin")
@CommandPermission(value="atom.skin")
public class SkinCommand
extends BaseCommand {
    @Subcommand(value="set")
    @CommandPermission(value="atom.skin.set")
    public void setSkin(Player player, String username) {
        ActionBarManager.send(player, "\u00a77Fetching skin from \u00a7e" + username + "\u00a77...");
        SkinAPI.setSkinFromUsername(player, username).thenAccept(success -> {
            if (success.booleanValue()) {
                ActionBarManager.send(player, "\u00a7aSkin changed to " + username + "'s skin!");
            } else {
                ActionBarManager.send(player, "\u00a7cFailed to fetch skin from " + username);
            }
        });
    }

    @Subcommand(value="setdefault")
    @CommandPermission(value="atom.skin.setdefault")
    public void setDefaultSkin(Player player, String username) {
        ActionBarManager.send(player, "\u00a77Setting default skin to \u00a7e" + username + "\u00a77...");
        SkinAPI.setSkinFromUsername(player, username).thenAccept(success -> {
            if (success.booleanValue()) {
                YamlConfiguration serverData = Atom.getInstance().getDataStorage().getServerData();
                serverData.set("default_skin_username", (Object)username);
                Atom.getInstance().getDataStorage().saveServerData(serverData);
                ActionBarManager.send(player, "\u00a7aDefault skin set to " + username + "'s skin!");
                ActionBarManager.send(player, "\u00a77All players will receive this skin on join.");
            } else {
                ActionBarManager.send(player, "\u00a7cFailed to fetch skin from " + username);
            }
        });
    }

    @Subcommand(value="reset")
    @CommandPermission(value="atom.skin.reset")
    public void resetSkin(Player player) {
        SkinAPI.setDefaultSkin(player);
        ActionBarManager.send(player, "\u00a7aSkin reset to default!");
    }
}

