/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.blocks.anvil;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.RegionAccessor;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;
import org.shotrush.atom.Atom;
import org.shotrush.atom.core.blocks.CustomBlock;
import org.shotrush.atom.core.blocks.InteractiveSurface;
import org.shotrush.atom.core.blocks.annotation.AutoRegister;
import org.shotrush.atom.core.blocks.util.BlockRotationUtil;
import org.shotrush.atom.core.util.ActionBarManager;

@AutoRegister(priority=20)
public class AnvilSurface
extends InteractiveSurface {
    public AnvilSurface(Location spawnLocation, Location blockLocation, BlockFace blockFace) {
        super(spawnLocation, blockLocation, blockFace);
    }

    public AnvilSurface(Location spawnLocation, BlockFace blockFace) {
        super(spawnLocation, blockFace);
    }

    @Override
    public int getMaxItems() {
        return 2;
    }

    @Override
    public boolean canPlaceItem(ItemStack item) {
        return item != null && item.getType() != Material.AIR;
    }

    @Override
    public Vector3f calculatePlacement(Player player, int itemCount) {
        float[][] positions = new float[][]{{-0.25f, 0.6f, 0.0f}, {0.25f, 0.6f, 0.0f}};
        if (itemCount < positions.length) {
            return new Vector3f(positions[itemCount][0], positions[itemCount][1], positions[itemCount][2]);
        }
        return new Vector3f(0.0f, 0.6f, 0.0f);
    }

    @Override
    public void spawn(Atom plugin, RegionAccessor accessor) {
        this.cleanupExistingEntities();
        ItemDisplay base = (ItemDisplay)accessor.spawnEntity(this.spawnLocation, EntityType.ITEM_DISPLAY);
        ItemStack anvilItem = new ItemStack(Material.ANVIL);
        this.spawnDisplay(base, plugin, anvilItem, new Vector3f(0.0f, 0.5f, 0.0f), new AxisAngle4f(), new Vector3f(1.0f, 1.0f, 1.0f), true, 1.0f, 1.0f);
    }

    @Override
    protected AxisAngle4f getItemDisplayRotation(InteractiveSurface.PlacedItem item) {
        float yawRadians = (float)Math.toRadians(item.getYaw());
        AxisAngle4f yawRotation = new AxisAngle4f(yawRadians, 0.0f, 1.0f, 0.0f);
        AxisAngle4f tiltRotation = new AxisAngle4f(1.5707964f, 1.0f, 0.0f, 0.0f);
        return BlockRotationUtil.combineRotations(yawRotation, tiltRotation);
    }

    @Override
    protected Vector3f getItemDisplayTranslation(InteractiveSurface.PlacedItem item) {
        return new Vector3f(0.0f, 0.45f, 0.0f);
    }

    @Override
    protected Vector3f getItemDisplayScale(InteractiveSurface.PlacedItem item) {
        return new Vector3f(0.3f, 0.3f, 0.3f);
    }

    @Override
    public void update(float globalAngle) {
    }

    @Override
    protected void removeEntities() {
        for (InteractiveSurface.PlacedItem item : this.placedItems) {
            this.removeItemDisplay(item);
            if (this.blockLocation.getWorld() == null) continue;
            this.blockLocation.getWorld().dropItemNaturally(this.blockLocation, item.getItem());
        }
        super.removeEntities();
    }

    @Override
    public String getBlockType() {
        return "anvil_surface";
    }

    @Override
    public boolean onWrenchInteract(Player player, boolean sneaking) {
        if (sneaking) {
            ItemStack removed = this.removeLastItem();
            if (removed != null) {
                player.getInventory().addItem(new ItemStack[]{removed});
                ActionBarManager.send(player, "\u00a77Removed item (" + this.placedItems.size() + "/" + this.getMaxItems() + ")");
                return true;
            }
            return false;
        }
        ItemStack hand = player.getInventory().getItemInMainHand();
        if (hand.getType() == Material.WOODEN_HOE) {
            return false;
        }
        if (hand.getType() == Material.AIR) {
            return false;
        }
        Vector3f pos = this.calculatePlacement(player, this.placedItems.size());
        if (this.placeItem(player, hand, pos, player.getLocation().getYaw())) {
            hand.setAmount(hand.getAmount() - 1);
            ActionBarManager.send(player, "\u00a7aPlaced item (" + this.placedItems.size() + "/" + this.getMaxItems() + ")");
            return true;
        }
        ActionBarManager.send(player, "\u00a7cSurface is full!");
        return false;
    }

    @Override
    public String getIdentifier() {
        return "anvil_surface";
    }

    @Override
    public String getDisplayName() {
        return "\u00a77\u2692 Anvil Surface";
    }

    @Override
    public Material getItemMaterial() {
        return Material.ANVIL;
    }

    @Override
    public String[] getLore() {
        return new String[]{"\u00a77Place up to 2 items on this surface", "\u00a78\u2022 Right-click: Place item", "\u00a78\u2022 Shift + Right-click: Remove item"};
    }

    @Override
    public CustomBlock deserialize(String data) {
        Object[] parsed = this.parseDeserializeData(data);
        if (parsed == null) {
            return null;
        }
        AnvilSurface surface = new AnvilSurface((Location)parsed[1], (BlockFace)parsed[2]);
        String[] parts = data.split(";");
        surface.deserializeAdditionalData(parts, 5);
        return surface;
    }
}

