/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.blocks.cog;

import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.RegionAccessor;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Transformation;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;
import org.shotrush.atom.Atom;
import org.shotrush.atom.content.blocks.cog.CogManager;
import org.shotrush.atom.core.blocks.CustomBlock;
import org.shotrush.atom.core.blocks.annotation.AutoRegister;
import org.shotrush.atom.core.blocks.util.BlockRotationUtil;
import org.shotrush.atom.core.util.ActionBarManager;

@AutoRegister(priority=10)
public class Cog
extends CustomBlock {
    private boolean isPowerSource;
    private boolean isPowered;
    private int rotationDirection;

    public Cog(Location spawnLocation, Location blockLocation, BlockFace blockFace) {
        super(spawnLocation, blockLocation, blockFace);
        this.isPowerSource = false;
        this.isPowered = false;
        this.rotationDirection = 1;
    }

    public Cog(Location spawnLocation, BlockFace blockFace, boolean isPowerSource) {
        super(spawnLocation, blockFace);
        this.isPowerSource = isPowerSource;
        this.isPowered = isPowerSource;
        this.rotationDirection = 1;
    }

    @Override
    public String getBlockType() {
        return "cog_small";
    }

    @Override
    protected String serializeAdditionalData() {
        return String.valueOf(this.isPowerSource);
    }

    @Override
    public void update(float globalAngle) {
        this.updateRotation(globalAngle);
    }

    @Override
    public void spawn(Atom plugin, RegionAccessor accessor) {
        this.cleanupExistingEntities();
        ItemDisplay display = (ItemDisplay)accessor.spawnEntity(this.spawnLocation, EntityType.ITEM_DISPLAY);
        String modelName = this.isPowerSource ? "cog_small_powered" : "cog_small";
        ItemStack diamondItem = this.createItemWithCustomModel(Material.STONE_BUTTON, modelName);
        AxisAngle4f initialRotation = BlockRotationUtil.getInitialRotationFromFace(this.blockFace);
        this.spawnDisplay(display, plugin, diamondItem, new Vector3f(0.0f, 0.5f, 0.0f), initialRotation, new Vector3f(1.0f, 1.0f, 1.0f), true, 1.0f, 1.0f);
    }

    public void updateRotation(float globalAngle) {
        if (!this.isPowered) {
            return;
        }
        this.updateDisplayRotation(globalAngle, this.rotationDirection, new Vector3f(0.0f, 0.5f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f));
    }

    public void togglePowerSource() {
        this.isPowered = this.isPowerSource = !this.isPowerSource;
        Entity entity = Bukkit.getEntity((UUID)this.displayUUID);
        if (entity instanceof ItemDisplay) {
            ItemDisplay display = (ItemDisplay)entity;
            Transformation currentTransform = display.getTransformation();
            String modelName = this.isPowerSource ? "cog_small_powered" : "cog_small";
            ItemStack diamondItem = this.createItemWithCustomModel(Material.STONE_BUTTON, modelName);
            display.setInterpolationDuration(0);
            display.setInterpolationDelay(0);
            display.setItemStack(diamondItem);
            display.setTransformation(currentTransform);
            display.teleportAsync(display.getLocation());
        }
    }

    public void setPowerSource(boolean powerSource) {
        this.isPowerSource = powerSource;
        if (powerSource) {
            this.isPowered = true;
        }
    }

    public void setPowered(boolean powered) {
        this.isPowered = this.isPowerSource ? true : powered;
    }

    public boolean isSameAxisAs(Cog other) {
        return BlockRotationUtil.isSameAxis(this.blockFace, other.blockFace);
    }

    public boolean isConnectedAlongAxis(Cog other) {
        Location thisLoc = this.getBlockLocation();
        Location otherLoc = other.getBlockLocation();
        int dx = Math.abs(thisLoc.getBlockX() - otherLoc.getBlockX());
        int dy = Math.abs(thisLoc.getBlockY() - otherLoc.getBlockY());
        int dz = Math.abs(thisLoc.getBlockZ() - otherLoc.getBlockZ());
        BlockRotationUtil.Axis axis = BlockRotationUtil.getAxis(this.blockFace);
        return switch (axis) {
            case BlockRotationUtil.Axis.Y -> {
                if (dy > 0 && dx == 0 && dz == 0) {
                    yield true;
                }
                yield false;
            }
            case BlockRotationUtil.Axis.Z -> {
                if (dz > 0 && dx == 0 && dy == 0) {
                    yield true;
                }
                yield false;
            }
            case BlockRotationUtil.Axis.X -> {
                if (dx > 0 && dy == 0 && dz == 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public boolean onWrenchInteract(Player player, boolean sneaking) {
        if (sneaking) {
            return false;
        }
        this.togglePowerSource();
        ActionBarManager.send(player, this.isPowerSource ? "\u00a7aCog is now a power source!" : "\u00a77Cog is no longer a power source");
        CogManager cogManager = new CogManager(Atom.getInstance());
        cogManager.recalculatePower(Atom.getInstance().getBlockManager().getBlocks());
        return true;
    }

    @Override
    public void onPlaced() {
        CogManager cogManager = new CogManager(Atom.getInstance());
        cogManager.recalculatePower(Atom.getInstance().getBlockManager().getBlocks());
    }

    @Override
    public void onRemoved() {
        CogManager cogManager = new CogManager(Atom.getInstance());
        cogManager.recalculatePower(Atom.getInstance().getBlockManager().getBlocks());
    }

    @Override
    public String getIdentifier() {
        return "cog_small";
    }

    @Override
    public String getDisplayName() {
        return "\u00a76\u2699 Mechanical Cog";
    }

    @Override
    public Material getItemMaterial() {
        return Material.STONE_BUTTON;
    }

    @Override
    public String[] getLore() {
        return new String[]{"\u00a77Place this item to create a", "\u00a77rotating mechanical cog", "\u00a78\u2022 Use a wrench to power/remove", "\u00a78[Mechanical Component]"};
    }

    @Override
    public CustomBlock deserialize(String data) {
        try {
            String[] parts = data.split(";");
            World world = Bukkit.getWorld((String)parts[0]);
            if (world == null) {
                return null;
            }
            Location location = new Location(world, Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
            BlockFace face = BlockFace.valueOf((String)parts[4]);
            boolean isPowerSource = false;
            if (parts.length > 5) {
                isPowerSource = Boolean.parseBoolean(parts[5]);
            }
            return new Cog(location, face, isPowerSource);
        }
        catch (Exception e) {
            Atom.getInstance().getLogger().warning("Failed to deserialize Cog: " + e.getMessage());
            return null;
        }
    }

    @Override
    public boolean requiresUpdate() {
        return true;
    }

    @Generated
    public boolean isPowerSource() {
        return this.isPowerSource;
    }

    @Generated
    public int getRotationDirection() {
        return this.rotationDirection;
    }

    @Generated
    public void setRotationDirection(int rotationDirection) {
        this.rotationDirection = rotationDirection;
    }
}

