/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.foragingage.items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.core.data.PersistentData;
import org.shotrush.atom.core.items.CustomItem;
import org.shotrush.atom.core.items.annotation.AutoRegister;
import org.shotrush.atom.core.util.ItemUtil;

@AutoRegister(priority=1)
public class Waterskin
extends CustomItem {
    private static final int MAX_WATER = 5;

    public Waterskin(Plugin plugin) {
        super(plugin);
    }

    @Override
    public String getIdentifier() {
        return "waterskin";
    }

    @Override
    public Material getMaterial() {
        return Material.POTION;
    }

    @Override
    public String getDisplayName() {
        return "\u00a76Waterskin";
    }

    @Override
    public List<String> getLore() {
        return Arrays.asList("\u00a77A leather container for water", "\u00a77Right-click water to fill", "\u00a77Right-click to drink", "\u00a78Capacity: 5 uses");
    }

    @Override
    protected void applyCustomMeta(ItemMeta meta) {
        ItemUtil.setCustomModelName(meta, "waterskin");
        PersistentData.set((PersistentDataHolder)meta, "water_amount", 0);
        PersistentData.set((PersistentDataHolder)meta, "water_purified", false);
    }

    public static int getWaterAmount(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return 0;
        }
        return PersistentData.getInt((PersistentDataHolder)item.getItemMeta(), "water_amount", 0);
    }

    public static boolean isPurified(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        return PersistentData.getBoolean((PersistentDataHolder)item.getItemMeta(), "water_purified", false);
    }

    public static void setWater(ItemStack item, int amount, boolean purified) {
        if (item == null || item.getType() != Material.POTION) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentData.set((PersistentDataHolder)meta, "water_amount", Math.min(amount, 5));
        PersistentData.set((PersistentDataHolder)meta, "water_purified", purified);
        Waterskin.updateLore(meta, amount, purified);
        item.setItemMeta(meta);
    }

    public static void addWater(ItemStack item, int amount, boolean purified) {
        int current = Waterskin.getWaterAmount(item);
        boolean currentPurified = Waterskin.isPurified(item);
        boolean newPurified = currentPurified || purified;
        Waterskin.setWater(item, current + amount, newPurified);
    }

    public static void drinkWater(ItemStack item) {
        int current = Waterskin.getWaterAmount(item);
        if (current > 0) {
            Waterskin.setWater(item, current - 1, Waterskin.isPurified(item));
        }
    }

    private static void updateLore(ItemMeta meta, int amount, boolean purified) {
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("\u00a77A leather container for water");
        lore.add("\u00a77Right-click water to fill");
        lore.add("\u00a77Right-click to drink");
        lore.add("\u00a78Capacity: 5 uses");
        lore.add("");
        lore.add("\u00a77Water: " + amount + "/5");
        if (purified) {
            lore.add("\u00a7aPurified Water");
        } else if (amount > 0) {
            lore.add("\u00a7cRaw Water");
        }
        meta.setLore(lore);
    }
}

