/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.foragingage.items;

import org.bukkit.FluidCollisionMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.RayTraceResult;
import org.shotrush.atom.content.foragingage.items.Waterskin;
import org.shotrush.atom.core.api.annotation.RegisterSystem;
import org.shotrush.atom.core.data.PersistentData;

@RegisterSystem(id="waterskin_handler", priority=3, toggleable=true, description="Handles waterskin filling and drinking")
public class WaterskinHandler
implements Listener {
    private final Plugin plugin;

    public WaterskinHandler(Plugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onWaterskinUse(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null || !this.isWaterskin(item)) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            RayTraceResult result = player.rayTraceBlocks(5.0, FluidCollisionMode.SOURCE_ONLY);
            if (result != null && result.getHitBlock() != null && this.isWaterSource(result.getHitBlock().getType())) {
                this.fillWaterskin(player, item, result.getHitBlock());
                event.setCancelled(true);
            } else if (Waterskin.getWaterAmount(item) > 0) {
                this.drinkWaterskin(player, item);
                event.setCancelled(true);
            }
        }
    }

    private boolean isWaterskin(ItemStack item) {
        if (!item.hasItemMeta()) {
            return false;
        }
        String itemId = PersistentData.getString((PersistentDataHolder)item.getItemMeta(), "custom_item_id", null);
        return "waterskin".equals(itemId);
    }

    private boolean isWaterSource(Material material) {
        return material == Material.WATER || material == Material.WATER_CAULDRON;
    }

    private void fillWaterskin(Player player, ItemStack item, Block block) {
        int currentAmount = Waterskin.getWaterAmount(item);
        if (currentAmount >= 5) {
            player.sendMessage("\u00a7cYour waterskin is already full!");
            return;
        }
        boolean isPurified = block.getType() == Material.WATER_CAULDRON;
        Waterskin.setWater(item, 5, isPurified);
        if (isPurified) {
            player.sendMessage("\u00a7aFilled waterskin with purified water");
        } else {
            player.sendMessage("\u00a7eFilled waterskin with raw water");
            player.sendMessage("\u00a77\u00a7oRaw water may cause sickness...");
        }
        player.playSound(player.getLocation(), Sound.ITEM_BOTTLE_FILL, 1.0f, 1.0f);
    }

    private void drinkWaterskin(Player player, ItemStack item) {
        int currentAmount = Waterskin.getWaterAmount(item);
        if (currentAmount <= 0) {
            player.sendMessage("\u00a7cYour waterskin is empty!");
            return;
        }
        boolean isPurified = Waterskin.isPurified(item);
        Waterskin.drinkWater(item);
        int currentFood = player.getFoodLevel();
        float currentSaturation = player.getSaturation();
        player.setFoodLevel(Math.min(20, currentFood + 1));
        player.setSaturation(Math.min(20.0f, currentSaturation + 2.0f));
        if (isPurified) {
            player.sendMessage("\u00a7aYou drink purified water");
            player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 40, 0, false, false));
        } else {
            player.sendMessage("\u00a7eYou drink raw water");
            if (Math.random() < 0.3) {
                player.sendMessage("\u00a7c\u00a7oYou feel sick from the raw water...");
                player.addPotionEffect(new PotionEffect(PotionEffectType.NAUSEA, 100, 0, false, true));
                player.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, 200, 0, false, false));
            }
        }
        player.playSound(player.getLocation(), Sound.ENTITY_GENERIC_DRINK, 1.0f, 1.0f);
        int remaining = Waterskin.getWaterAmount(item);
        if (remaining > 0) {
            player.sendMessage("\u00a77Water remaining: " + remaining + "/5");
        } else {
            player.sendMessage("\u00a77Your waterskin is now empty");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWaterskinConsume(PlayerItemConsumeEvent event) {
        ItemStack item = event.getItem();
        if (this.isWaterskin(item)) {
            event.setCancelled(true);
        }
    }
}

