/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.shotrush.atom.Atom;
import org.shotrush.atom.content.mobs.AnimalDomestication;

public class AnimalBehavior
implements Listener {
    private final Atom plugin;
    private static final Set<EntityType> COMMON_ANIMALS = new HashSet<EntityType>();
    private static final double AGGRESSION_CHANCE = 0.65;
    private static final double FLEE_DISTANCE = 10.0;
    private static final double INJURED_THRESHOLD = 0.4;
    private final Set<UUID> trackedAnimals = new HashSet<UUID>();

    public AnimalBehavior(Atom plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onAnimalSpawn(CreatureSpawnEvent event) {
        LivingEntity entity = event.getEntity();
        if (!COMMON_ANIMALS.contains(entity.getType())) {
            return;
        }
        if (!(entity instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)entity;
        if (AnimalDomestication.isFullyDomesticated(animal)) {
            this.plugin.getLogger().info("Fully domesticated " + String.valueOf(animal.getType()) + " spawned - skipping enhancement");
            return;
        }
        this.plugin.getLogger().info("Animal spawned: " + String.valueOf(animal.getType()) + " at " + String.valueOf(animal.getLocation()) + " (Reason: " + String.valueOf(event.getSpawnReason()) + ")");
        double domesticationFactor = AnimalDomestication.getDomesticationFactor(animal);
        this.enhanceAnimalStats(animal, domesticationFactor);
        double adjustedAggressionChance = 0.65 * (1.0 - domesticationFactor);
        boolean isAggressive = Math.random() < adjustedAggressionChance;
        animal.setMetadata("aggressive", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)isAggressive));
        this.plugin.getLogger().info("Animal is aggressive: " + isAggressive);
        double maxStamina = 100.0 + Math.random() * 100.0;
        animal.setMetadata("maxStamina", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)maxStamina));
        animal.setMetadata("stamina", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)maxStamina));
        animal.setMetadata("fleeing", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)false));
        this.trackedAnimals.add(animal.getUniqueId());
        if (isAggressive && entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            wolf.setAngry(true);
        }
        animal.getScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> {
            if (animal.isDead() || !animal.isValid()) {
                this.trackedAnimals.remove(animal.getUniqueId());
                scheduledTask.cancel();
                return;
            }
            this.handleAnimalBehavior(animal);
        }, null, 1L, 10L);
    }

    private void enhanceAnimalStats(Animals animal, double domesticationFactor) {
        double wildFactor = 1.0 - domesticationFactor;
        if (animal.getAttribute(Attribute.MAX_HEALTH) != null) {
            double currentMax = Objects.requireNonNull(animal.getAttribute(Attribute.MAX_HEALTH)).getBaseValue();
            double healthMultiplier = 1.0 + 0.5 * wildFactor;
            Objects.requireNonNull(animal.getAttribute(Attribute.MAX_HEALTH)).setBaseValue(currentMax * healthMultiplier);
            animal.setHealth(Objects.requireNonNull(animal.getAttribute(Attribute.MAX_HEALTH)).getValue());
        }
        if (animal.getAttribute(Attribute.KNOCKBACK_RESISTANCE) != null) {
            Objects.requireNonNull(animal.getAttribute(Attribute.KNOCKBACK_RESISTANCE)).setBaseValue(0.5 * wildFactor);
        }
        if (animal.getAttribute(Attribute.MOVEMENT_SPEED) != null) {
            double currentSpeed = Objects.requireNonNull(animal.getAttribute(Attribute.MOVEMENT_SPEED)).getBaseValue();
            double speedMultiplier = 1.0 + 0.35 * wildFactor;
            Objects.requireNonNull(animal.getAttribute(Attribute.MOVEMENT_SPEED)).setBaseValue(currentSpeed * speedMultiplier);
        }
    }

    @EventHandler
    public void onAnimalDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)entity;
        if (!COMMON_ANIMALS.contains(animal.getType())) {
            return;
        }
        Player attacker = null;
        if (event.getDamager() instanceof Player) {
            attacker = (Player)event.getDamager();
        } else {
            Projectile projectile;
            Entity entity2 = event.getDamager();
            if (entity2 instanceof Projectile && (projectile = (Projectile)entity2).getShooter() instanceof Player) {
                attacker = (Player)projectile.getShooter();
            }
        }
        if (attacker == null) {
            return;
        }
        double healthPercent = animal.getHealth() / Objects.requireNonNull(animal.getAttribute(Attribute.MAX_HEALTH)).getValue();
        if (healthPercent < 0.4) {
            this.switchToFleeing(animal);
        }
    }

    private void switchToFleeing(Animals animal) {
        if (animal.hasMetadata("fleeing") && ((MetadataValue)animal.getMetadata("fleeing").getFirst()).asBoolean()) {
            return;
        }
        animal.setMetadata("fleeing", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        if (animal instanceof Mob) {
            Animals mob = animal;
            mob.setTarget(null);
        }
        this.makeFlee(animal);
    }

    private void makeFlee(Animals animal) {
        this.plugin.getLogger().info("Making " + String.valueOf(animal.getType()) + " flee");
    }

    private void handleAnimalBehavior(Animals animal) {
        if (!animal.hasMetadata("aggressive")) {
            return;
        }
        boolean isAggressive = ((MetadataValue)animal.getMetadata("aggressive").getFirst()).asBoolean();
        boolean isFleeing = animal.hasMetadata("fleeing") && ((MetadataValue)animal.getMetadata("fleeing").getFirst()).asBoolean();
        Player nearestPlayer = this.getNearestPlayer(animal);
        if (nearestPlayer == null) {
            if (animal instanceof Mob) {
                Animals mob = animal;
                mob.setTarget(null);
            }
            return;
        }
        double healthPercent = animal.getHealth() / Objects.requireNonNull(animal.getAttribute(Attribute.MAX_HEALTH)).getValue();
        int nearbyPlayers = animal.getLocation().getNearbyPlayers(15.0).size();
        if (healthPercent < 0.4 || isFleeing && healthPercent < 0.7) {
            if (!isFleeing) {
                this.switchToFleeing(animal);
            }
            this.handleFleeingBehavior(animal, nearestPlayer, nearbyPlayers);
        } else if (!isAggressive && !isFleeing && nearestPlayer.getLocation().distance(animal.getLocation()) < 10.0) {
            this.switchToFleeing(animal);
        }
    }

    private void handleFleeingBehavior(Animals animal, Player nearestPlayer, int nearbyPlayers) {
        if (!animal.hasMetadata("stamina")) {
            return;
        }
        double stamina = ((MetadataValue)animal.getMetadata("stamina").getFirst()).asDouble();
        double maxStamina = ((MetadataValue)animal.getMetadata("maxStamina").getFirst()).asDouble();
        double distance = animal.getLocation().distance(nearestPlayer.getLocation());
        if (distance < 20.0 && stamina > 0.0) {
            Vector direction = animal.getLocation().toVector().subtract(nearestPlayer.getLocation().toVector()).normalize();
            double fleeDistance = 15.0 * (stamina / maxStamina);
            Location fleeTarget = animal.getLocation().add(direction.multiply(fleeDistance));
            if (animal instanceof Mob) {
                Animals mob = animal;
                mob.setTarget(null);
                double domesticationFactor = AnimalDomestication.getDomesticationFactor(animal);
                double fleeSpeed = 1.4 * (1.0 - domesticationFactor * 0.5);
                mob.getPathfinder().moveTo(fleeTarget, fleeSpeed);
            }
            double staminaDrain = 0.2 + (double)nearbyPlayers * 0.1;
            double healthPercent = animal.getHealth() / Objects.requireNonNull(animal.getAttribute(Attribute.MAX_HEALTH)).getValue();
            stamina = Math.max(0.0, stamina - (staminaDrain *= 1.0 + (1.0 - healthPercent) * 0.5));
            animal.setMetadata("stamina", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)stamina));
        } else if (distance >= 60.0 && stamina < maxStamina) {
            stamina = Math.min(maxStamina, stamina + 2.0);
            animal.setMetadata("stamina", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)stamina));
        }
    }

    private Player getNearestPlayer(Animals animal) {
        Player nearest = null;
        double nearestDist = 10.0;
        for (Player player : animal.getLocation().getNearbyPlayers(10.0)) {
            double dist = player.getLocation().distance(animal.getLocation());
            if (!(dist < nearestDist)) continue;
            nearest = player;
            nearestDist = dist;
        }
        return nearest;
    }

    static {
        COMMON_ANIMALS.add(EntityType.COW);
        COMMON_ANIMALS.add(EntityType.PIG);
        COMMON_ANIMALS.add(EntityType.SHEEP);
        COMMON_ANIMALS.add(EntityType.CHICKEN);
        COMMON_ANIMALS.add(EntityType.RABBIT);
        COMMON_ANIMALS.add(EntityType.HORSE);
        COMMON_ANIMALS.add(EntityType.DONKEY);
        COMMON_ANIMALS.add(EntityType.MULE);
        COMMON_ANIMALS.add(EntityType.LLAMA);
        COMMON_ANIMALS.add(EntityType.GOAT);
        COMMON_ANIMALS.add(EntityType.CAT);
        COMMON_ANIMALS.add(EntityType.WOLF);
        COMMON_ANIMALS.add(EntityType.FOX);
        COMMON_ANIMALS.add(EntityType.PANDA);
        COMMON_ANIMALS.add(EntityType.POLAR_BEAR);
        COMMON_ANIMALS.add(EntityType.OCELOT);
        COMMON_ANIMALS.add(EntityType.TURTLE);
        COMMON_ANIMALS.add(EntityType.STRIDER);
        COMMON_ANIMALS.add(EntityType.AXOLOTL);
        COMMON_ANIMALS.add(EntityType.FROG);
        COMMON_ANIMALS.add(EntityType.CAMEL);
        COMMON_ANIMALS.add(EntityType.SNIFFER);
        COMMON_ANIMALS.add(EntityType.ARMADILLO);
    }
}

