/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.MobGoals;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.Atom;
import org.shotrush.atom.content.mobs.AnimalDomestication;
import org.shotrush.atom.content.mobs.ai.combat.FatigueSystem;
import org.shotrush.atom.content.mobs.ai.combat.InjurySystem;
import org.shotrush.atom.content.mobs.ai.combat.MoraleSystem;
import org.shotrush.atom.content.mobs.ai.config.SpeciesBehavior;
import org.shotrush.atom.content.mobs.ai.goals.AcquireNearestPlayerTargetGoal;
import org.shotrush.atom.content.mobs.ai.goals.AvoidPlayerWhenInjuredGoal;
import org.shotrush.atom.content.mobs.ai.goals.ChaseAndMeleeAttackGoal;
import org.shotrush.atom.content.mobs.ai.goals.CounterChargeGoal;
import org.shotrush.atom.content.mobs.ai.goals.CubProtectionGoal;
import org.shotrush.atom.content.mobs.ai.goals.DeathEffectsGoal;
import org.shotrush.atom.content.mobs.ai.goals.FlankAndSurroundGoal;
import org.shotrush.atom.content.mobs.ai.goals.FlightBurstGoal;
import org.shotrush.atom.content.mobs.ai.goals.HerdLeaderWanderGoal;
import org.shotrush.atom.content.mobs.ai.goals.HerdPanicGoal;
import org.shotrush.atom.content.mobs.ai.goals.HuntPreyGoal;
import org.shotrush.atom.content.mobs.ai.goals.KickAttackGoal;
import org.shotrush.atom.content.mobs.ai.goals.PackHuntingGoal;
import org.shotrush.atom.content.mobs.ai.goals.PounceAttackGoal;
import org.shotrush.atom.content.mobs.ai.goals.RamChargeGoal;
import org.shotrush.atom.content.mobs.ai.goals.ReunionGoal;
import org.shotrush.atom.content.mobs.ai.goals.RollDefenseGoal;
import org.shotrush.atom.content.mobs.ai.goals.SentryBehaviorGoal;
import org.shotrush.atom.content.mobs.ai.goals.SpitAttackGoal;
import org.shotrush.atom.content.mobs.ai.goals.StalkPreyGoal;
import org.shotrush.atom.content.mobs.ai.goals.StampedeGoal;
import org.shotrush.atom.content.mobs.ai.goals.StayNearHerdGoal;
import org.shotrush.atom.content.mobs.ai.goals.TerritoryDefenseGoal;
import org.shotrush.atom.content.mobs.ai.goals.TrackWoundedPreyGoal;
import org.shotrush.atom.content.mobs.herd.Herd;
import org.shotrush.atom.content.mobs.herd.HerdManager;
import org.shotrush.atom.content.mobs.herd.HerdRole;
import org.shotrush.atom.core.api.scheduler.SchedulerAPI;

public class AnimalBehaviorNew
implements Listener {
    private final Atom plugin;
    private static HerdManager herdManager;
    private final InjurySystem injurySystem;
    private final FatigueSystem fatigueSystem;
    private final MoraleSystem moraleSystem;
    private static final Set<EntityType> COMMON_ANIMALS;
    private final Set<UUID> trackedAnimals = new HashSet<UUID>();

    public AnimalBehaviorNew(Plugin plugin) {
        this.plugin = (Atom)plugin;
        herdManager = new HerdManager((Atom)plugin);
        this.injurySystem = new InjurySystem(plugin);
        this.fatigueSystem = new FatigueSystem(plugin);
        this.moraleSystem = new MoraleSystem(plugin, herdManager);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onAnimalSpawn(CreatureSpawnEvent event) {
        LivingEntity entity = event.getEntity();
        if (!COMMON_ANIMALS.contains(entity.getType())) {
            return;
        }
        if (!(entity instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)entity;
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        mob.setRemoveWhenFarAway(false);
        mob.setPersistent(true);
        if (animal.getAttribute(Attribute.STEP_HEIGHT) != null) {
            Objects.requireNonNull(animal.getAttribute(Attribute.STEP_HEIGHT)).setBaseValue(1.0);
        }
        if (animal.getAttribute(Attribute.ATTACK_DAMAGE) == null) {
            animal.registerAttribute(Attribute.ATTACK_DAMAGE);
            Objects.requireNonNull(animal.getAttribute(Attribute.ATTACK_DAMAGE)).setBaseValue(2.0);
        }
        if (AnimalDomestication.isFullyDomesticated(animal)) {
            return;
        }
        this.initializeAnimal(animal, mob);
    }

    private void enhanceAnimalStats(Animals animal, double domesticationFactor, SpeciesBehavior behavior) {
        double wildFactor = 1.0 - domesticationFactor;
        NamespacedKey wildnessKey = new NamespacedKey((Plugin)this.plugin, "wildness_modifier");
        if (animal.getAttribute(Attribute.MAX_HEALTH) != null) {
            AttributeInstance healthAttr = animal.getAttribute(Attribute.MAX_HEALTH);
            Objects.requireNonNull(healthAttr).getModifiers().forEach(mod -> {
                if (mod.getKey().equals((Object)wildnessKey)) {
                    healthAttr.removeModifier(mod);
                }
            });
            double healthBonus = 0.5 * wildFactor;
            if (healthBonus > 0.0) {
                AttributeModifier healthMod = new AttributeModifier(wildnessKey, healthBonus, AttributeModifier.Operation.MULTIPLY_SCALAR_1);
                healthAttr.addModifier(healthMod);
            }
            animal.setHealth(healthAttr.getValue());
        }
        if (animal.getAttribute(Attribute.KNOCKBACK_RESISTANCE) != null) {
            Objects.requireNonNull(animal.getAttribute(Attribute.KNOCKBACK_RESISTANCE)).setBaseValue(0.5 * wildFactor);
        }
        if (animal.getAttribute(Attribute.MOVEMENT_SPEED) != null) {
            AttributeInstance speedAttr = animal.getAttribute(Attribute.MOVEMENT_SPEED);
            speedAttr.getModifiers().forEach(mod -> {
                if (mod.getKey().equals((Object)wildnessKey)) {
                    speedAttr.removeModifier(mod);
                }
            });
            double speedBonus = 0.35 * wildFactor;
            if (speedBonus > 0.0) {
                AttributeModifier speedMod = new AttributeModifier(wildnessKey, speedBonus, AttributeModifier.Operation.MULTIPLY_SCALAR_1);
                speedAttr.addModifier(speedMod);
            }
        }
    }

    private void registerGoals(Mob mob, SpeciesBehavior behavior, boolean isAggressive, HerdRole role) {
        MobGoals goalSelector = Bukkit.getMobGoals();
        MobGoals targetSelector = Bukkit.getMobGoals();
        goalSelector.addGoal(mob, 0, (Goal)new DeathEffectsGoal(mob, this.plugin, herdManager, this.moraleSystem));
        goalSelector.addGoal(mob, 0, (Goal)new HerdPanicGoal(mob, this.plugin, herdManager, behavior, this.moraleSystem));
        goalSelector.addGoal(mob, 1, (Goal)new AvoidPlayerWhenInjuredGoal(mob, this.plugin, behavior));
        if (this.isCarnivore(mob.getType())) {
            goalSelector.addGoal(mob, 2, (Goal)new HuntPreyGoal(mob, this.plugin, behavior));
            goalSelector.addGoal(mob, 2, (Goal)new TrackWoundedPreyGoal(mob, this.plugin, this.injurySystem));
        }
        if (this.isPackHunter(mob.getType())) {
            goalSelector.addGoal(mob, 2, (Goal)new FlankAndSurroundGoal(mob, this.plugin, herdManager));
        }
        if (isAggressive) {
            targetSelector.addGoal(mob, 2, (Goal)new AcquireNearestPlayerTargetGoal(mob, this.plugin, behavior));
            goalSelector.addGoal(mob, 3, (Goal)new ChaseAndMeleeAttackGoal(mob, this.plugin, behavior, this.fatigueSystem, this.injurySystem, this.moraleSystem));
        }
        if (this.isCarnivore(mob.getType())) {
            goalSelector.addGoal(mob, 3, (Goal)new StalkPreyGoal(mob, this.plugin));
        }
        goalSelector.addGoal(mob, 3, (Goal)new ReunionGoal(mob, this.plugin, herdManager, behavior));
        if (role == HerdRole.FOLLOWER) {
            goalSelector.addGoal(mob, 4, (Goal)new StayNearHerdGoal(mob, this.plugin, herdManager, behavior));
        } else {
            goalSelector.addGoal(mob, 4, (Goal)new SentryBehaviorGoal(mob, this.plugin, herdManager));
            goalSelector.addGoal(mob, 4, (Goal)new TerritoryDefenseGoal(mob, this.plugin, herdManager));
            goalSelector.addGoal(mob, 6, (Goal)new HerdLeaderWanderGoal(mob, this.plugin, herdManager));
        }
        this.registerSpecialGoals(mob, behavior, goalSelector, isAggressive);
        this.plugin.getLogger().info("Registered goals for " + String.valueOf(mob.getType()) + " (aggressive: " + isAggressive + ", role: " + String.valueOf((Object)role) + ")");
    }

    private void registerSpecialGoals(Mob mob, SpeciesBehavior behavior, MobGoals goalSelector, boolean isAggressive) {
        switch (behavior.specialMechanic()) {
            case RAM_CHARGE: {
                if (!isAggressive || mob.getType() != EntityType.SHEEP && mob.getType() != EntityType.GOAT) break;
                goalSelector.addGoal(mob, 2, (Goal)new RamChargeGoal(mob, this.plugin));
                this.plugin.getLogger().info("  + Added Ram Charge");
                break;
            }
            case KICK_ATTACK: {
                if (!isAggressive || mob.getType() != EntityType.HORSE && mob.getType() != EntityType.DONKEY && mob.getType() != EntityType.MULE) break;
                goalSelector.addGoal(mob, 2, (Goal)new KickAttackGoal(mob, this.plugin));
                this.plugin.getLogger().info("  + Added Kick Attack");
                break;
            }
            case SPIT_ATTACK: {
                if (!isAggressive || mob.getType() != EntityType.LLAMA) break;
                goalSelector.addGoal(mob, 2, (Goal)new SpitAttackGoal(mob, this.plugin));
                this.plugin.getLogger().info("  + Added Spit Attack");
                break;
            }
            case COUNTER_CHARGE: {
                if (!isAggressive || mob.getType() != EntityType.PIG) break;
                goalSelector.addGoal(mob, 2, (Goal)new CounterChargeGoal(mob, this.plugin));
                this.plugin.getLogger().info("  + Added Counter Charge");
                break;
            }
            case PACK_HUNTING: {
                if (!isAggressive || mob.getType() != EntityType.WOLF) break;
                goalSelector.addGoal(mob, 2, (Goal)new PackHuntingGoal(mob, this.plugin, herdManager));
                this.plugin.getLogger().info("  + Added Pack Hunting");
                break;
            }
            case POUNCE_ATTACK: {
                if (!isAggressive || mob.getType() != EntityType.FOX) break;
                goalSelector.addGoal(mob, 2, (Goal)new PounceAttackGoal(mob, this.plugin));
                this.plugin.getLogger().info("  + Added Pounce Attack");
                break;
            }
            case STAMPEDE: {
                if (mob.getType() != EntityType.COW) break;
                goalSelector.addGoal(mob, 1, (Goal)new StampedeGoal(mob, this.plugin, herdManager));
                this.plugin.getLogger().info("  + Added Stampede");
                break;
            }
            case FLIGHT_BURST: {
                if (mob.getType() != EntityType.CHICKEN) break;
                goalSelector.addGoal(mob, 1, (Goal)new FlightBurstGoal(mob, this.plugin));
                this.plugin.getLogger().info("  + Added Flight Burst");
                break;
            }
            case CUB_PROTECTION: {
                if (mob.getType() != EntityType.POLAR_BEAR) break;
                goalSelector.addGoal(mob, 1, (Goal)new CubProtectionGoal(mob, this.plugin));
                this.plugin.getLogger().info("  + Added Cub Protection");
                break;
            }
            case ROLL_DEFENSE: {
                if (mob.getType() != EntityType.ARMADILLO) break;
                goalSelector.addGoal(mob, 0, (Goal)new RollDefenseGoal(mob, this.plugin));
                this.plugin.getLogger().info("  + Added Roll Defense");
                break;
            }
        }
    }

    private void startStaminaRegeneration(Animals animal) {
        SchedulerAPI.runTaskTimer((Entity)animal, scheduledTask -> {
            if (animal.isDead() || !animal.isValid()) {
                this.trackedAnimals.remove(animal.getUniqueId());
                scheduledTask.cancel();
                return;
            }
            this.regenerateStamina(animal);
        }, 1L, 40L);
    }

    private void regenerateStamina(Animals animal) {
        double maxStamina;
        boolean isFleeing;
        if (!animal.hasMetadata("stamina")) {
            return;
        }
        boolean bl = isFleeing = animal.hasMetadata("fleeing") && ((MetadataValue)animal.getMetadata("fleeing").get(0)).asBoolean();
        if (isFleeing) {
            return;
        }
        double stamina = ((MetadataValue)animal.getMetadata("stamina").get(0)).asDouble();
        if (stamina < (maxStamina = ((MetadataValue)animal.getMetadata("maxStamina").get(0)).asDouble())) {
            stamina = Math.min(maxStamina, stamina + 2.0);
            animal.setMetadata("stamina", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)stamina));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler
    public void onAnimalDamage(EntityDamageByEntityEvent event) {
        Player attacker;
        Entity entity = event.getEntity();
        if (!(entity instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)entity;
        if (!COMMON_ANIMALS.contains(animal.getType())) {
            return;
        }
        if (!(animal instanceof Mob)) {
            return;
        }
        Animals mob = animal;
        if (event.getDamager() instanceof Player) {
            attacker = (Player)event.getDamager();
        } else {
            Entity entity2 = event.getDamager();
            if (!(entity2 instanceof Projectile)) return;
            Projectile projectile = (Projectile)entity2;
            if (!(projectile.getShooter() instanceof Player)) return;
            attacker = (Player)projectile.getShooter();
        }
        this.injurySystem.applyInjuryEffects((Mob)mob);
        this.moraleSystem.checkMorale((Mob)mob);
        herdManager.getHerd(animal.getUniqueId()).ifPresent(herd -> {
            SpeciesBehavior behavior = SpeciesBehavior.get(animal.getType());
            herdManager.broadcastPanic((Herd)herd, attacker.getLocation(), behavior.panicDurationMs());
        });
        double healthPercent = animal.getHealth() / Objects.requireNonNull(animal.getAttribute(Attribute.MAX_HEALTH)).getValue();
        SpeciesBehavior behavior = SpeciesBehavior.get(animal.getType());
        if (!(healthPercent < behavior.panicHealthThreshold())) return;
        animal.setMetadata("fleeing", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
    }

    @EventHandler
    public void onAnimalDeath(EntityDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)livingEntity;
        if (!COMMON_ANIMALS.contains(animal.getType())) {
            return;
        }
        UUID animalId = animal.getUniqueId();
        herdManager.leaveHerd(animalId);
        this.trackedAnimals.remove(animalId);
        this.plugin.getLogger().info(">>> Animal died: " + String.valueOf(animal.getType()) + " - cleaned up all systems");
    }

    @EventHandler
    public void onEntitiesLoad(EntitiesLoadEvent event) {
        for (Entity entity : event.getEntities()) {
            if (!COMMON_ANIMALS.contains(entity.getType()) || !(entity instanceof Animals)) continue;
            Animals animal = (Animals)entity;
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            if (this.trackedAnimals.contains(animal.getUniqueId()) || AnimalDomestication.isFullyDomesticated(animal)) continue;
            this.initializeAnimal(animal, mob);
        }
    }

    private void initializeAnimal(Animals animal, Mob mob) {
        boolean isAggressive;
        double domesticationFactor = AnimalDomestication.getDomesticationFactor(animal);
        SpeciesBehavior behavior = SpeciesBehavior.get(animal.getType());
        if (!animal.hasMetadata("stats_enhanced")) {
            this.enhanceAnimalStats(animal, domesticationFactor, behavior);
            animal.setMetadata("stats_enhanced", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        }
        Herd herd = herdManager.getOrCreateHerd(animal);
        HerdRole role = herdManager.getRole(animal.getUniqueId());
        if (animal.hasMetadata("aggressive")) {
            isAggressive = ((MetadataValue)animal.getMetadata("aggressive").get(0)).asBoolean();
        } else {
            isAggressive = herdManager.getPersistence().isAggressive(animal);
            if (!isAggressive) {
                double aggressionChance = behavior.getAggressionChance(domesticationFactor);
                isAggressive = Math.random() < aggressionChance;
            }
            animal.setMetadata("aggressive", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)isAggressive));
        }
        double maxStamina = herdManager.getPersistence().getMaxStamina(animal, 100.0 + Math.random() * 100.0);
        double stamina = herdManager.getPersistence().getStamina(animal, maxStamina);
        animal.setMetadata("maxStamina", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)maxStamina));
        animal.setMetadata("stamina", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)stamina));
        animal.setMetadata("fleeing", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)false));
        herdManager.getPersistence().saveHerdData(animal, herd.id(), role == HerdRole.LEADER, isAggressive, maxStamina, stamina);
        this.trackedAnimals.add(animal.getUniqueId());
        this.registerGoals(mob, behavior, isAggressive, role);
        if (isAggressive && animal instanceof Wolf) {
            Wolf wolf = (Wolf)animal;
            wolf.setAngry(true);
        }
        this.plugin.getLogger().info(">>> Initialization complete!");
        this.startStaminaRegeneration(animal);
    }

    public HerdManager getHerdManager() {
        return herdManager;
    }

    private boolean isHerbivore(EntityType type) {
        return type == EntityType.COW || type == EntityType.SHEEP || type == EntityType.HORSE || type == EntityType.DONKEY || type == EntityType.MULE || type == EntityType.LLAMA || type == EntityType.GOAT || type == EntityType.RABBIT || type == EntityType.CHICKEN || type == EntityType.PIG || type == EntityType.CAMEL || type == EntityType.SNIFFER;
    }

    private boolean isCarnivore(EntityType type) {
        return type == EntityType.WOLF || type == EntityType.FOX || type == EntityType.CAT || type == EntityType.OCELOT || type == EntityType.POLAR_BEAR;
    }

    private boolean isPackHunter(EntityType type) {
        return type == EntityType.WOLF;
    }

    static {
        COMMON_ANIMALS = new HashSet<EntityType>();
        COMMON_ANIMALS.add(EntityType.COW);
        COMMON_ANIMALS.add(EntityType.PIG);
        COMMON_ANIMALS.add(EntityType.SHEEP);
        COMMON_ANIMALS.add(EntityType.CHICKEN);
        COMMON_ANIMALS.add(EntityType.RABBIT);
        COMMON_ANIMALS.add(EntityType.HORSE);
        COMMON_ANIMALS.add(EntityType.DONKEY);
        COMMON_ANIMALS.add(EntityType.MULE);
        COMMON_ANIMALS.add(EntityType.LLAMA);
        COMMON_ANIMALS.add(EntityType.GOAT);
        COMMON_ANIMALS.add(EntityType.CAT);
        COMMON_ANIMALS.add(EntityType.WOLF);
        COMMON_ANIMALS.add(EntityType.FOX);
        COMMON_ANIMALS.add(EntityType.PANDA);
        COMMON_ANIMALS.add(EntityType.POLAR_BEAR);
        COMMON_ANIMALS.add(EntityType.OCELOT);
        COMMON_ANIMALS.add(EntityType.TURTLE);
        COMMON_ANIMALS.add(EntityType.STRIDER);
        COMMON_ANIMALS.add(EntityType.AXOLOTL);
        COMMON_ANIMALS.add(EntityType.FROG);
        COMMON_ANIMALS.add(EntityType.CAMEL);
        COMMON_ANIMALS.add(EntityType.SNIFFER);
        COMMON_ANIMALS.add(EntityType.ARMADILLO);
    }
}

