/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs;

import java.util.Optional;
import org.bukkit.entity.Animals;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.Atom;
import org.shotrush.atom.content.mobs.herd.Herd;
import org.shotrush.atom.content.mobs.herd.HerdManager;
import org.shotrush.atom.core.api.AtomAPI;
import org.shotrush.atom.core.api.annotation.RegisterSystem;
import org.shotrush.atom.core.api.scheduler.SchedulerAPI;

@RegisterSystem(id="animal_domestication", priority=5, toggleable=true, dependencies={"animal_behavior"}, requires={"herd_manager"}, description="Handles animal breeding and domestication")
public class AnimalDomestication
implements Listener {
    private final Atom plugin;
    private final HerdManager herdManager;
    private static final int MAX_DOMESTICATION_LEVEL = 5;

    public AnimalDomestication(Plugin plugin) {
        this.plugin = (Atom)plugin;
        this.herdManager = AtomAPI.Systems.getService("herd_manager", HerdManager.class);
    }

    @EventHandler
    public void onAnimalBreed(EntityBreedEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Animals)) {
            return;
        }
        Animals baby = (Animals)livingEntity;
        LivingEntity livingEntity2 = event.getMother();
        if (!(livingEntity2 instanceof Animals)) {
            return;
        }
        Animals mother = (Animals)livingEntity2;
        LivingEntity livingEntity3 = event.getFather();
        if (!(livingEntity3 instanceof Animals)) {
            return;
        }
        Animals father = (Animals)livingEntity3;
        int motherLevel = this.getDomesticationLevel(mother);
        int fatherLevel = this.getDomesticationLevel(father);
        int babyLevel = Math.min(5, Math.max(motherLevel, fatherLevel) + 1);
        baby.setMetadata("domesticationLevel", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)babyLevel));
        this.plugin.getLogger().info("Baby " + String.valueOf(baby.getType()) + " born with domestication level: " + babyLevel);
        if (babyLevel >= 5) {
            baby.setMetadata("fullyDomesticated", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            this.plugin.getLogger().info("Baby is fully domesticated!");
        }
        SchedulerAPI.runTaskLater(baby.getLocation(), () -> {
            Optional<Herd> fatherHerd;
            Optional<Herd> motherHerd;
            Herd targetHerd;
            if (baby.isValid() && !baby.isDead() && (targetHerd = (motherHerd = this.herdManager.getHerd(mother.getUniqueId())).orElse((fatherHerd = this.herdManager.getHerd(father.getUniqueId())).orElse(null))) != null) {
                targetHerd.addMember(baby.getUniqueId());
                this.plugin.getLogger().info("Baby " + String.valueOf(baby.getType()) + " joined parent's herd: " + String.valueOf(targetHerd.id()));
            }
        }, 20L);
    }

    private int getDomesticationLevel(Animals animal) {
        if (animal.hasMetadata("domesticationLevel")) {
            return ((MetadataValue)animal.getMetadata("domesticationLevel").getFirst()).asInt();
        }
        return 0;
    }

    public static double getDomesticationFactor(Animals animal) {
        if (animal.hasMetadata("fullyDomesticated")) {
            return 1.0;
        }
        if (animal.hasMetadata("domesticationLevel")) {
            int level = ((MetadataValue)animal.getMetadata("domesticationLevel").getFirst()).asInt();
            return (double)level / 5.0;
        }
        return 0.0;
    }

    public static boolean isFullyDomesticated(Animals animal) {
        return animal.hasMetadata("fullyDomesticated");
    }
}

