/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Subcommand;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import org.shotrush.atom.Atom;
import org.shotrush.atom.content.mobs.AnimalDomestication;

@CommandAlias(value="domestication|dom")
@CommandPermission(value="atom.domestication")
public class DomesticationCommand
extends BaseCommand {
    @Default
    @Subcommand(value="check")
    public void checkDomestication(Player player) {
        RayTraceResult result = player.rayTraceEntities(5);
        if (result == null || result.getHitEntity() == null) {
            player.sendMessage("\u00a7cNo animal found. Look at an animal within 5 blocks.");
            return;
        }
        Entity entity = result.getHitEntity();
        if (!(entity instanceof Animals)) {
            player.sendMessage("\u00a7cThat's not an animal!");
            return;
        }
        Animals animal = (Animals)entity;
        double factor = AnimalDomestication.getDomesticationFactor(animal);
        int level = 0;
        if (animal.hasMetadata("domesticationLevel")) {
            level = ((MetadataValue)animal.getMetadata("domesticationLevel").getFirst()).asInt();
        }
        boolean fullyDomesticated = AnimalDomestication.isFullyDomesticated(animal);
        boolean isAggressive = animal.hasMetadata("aggressive") && ((MetadataValue)animal.getMetadata("aggressive").getFirst()).asBoolean();
        player.sendMessage("\u00a76=== " + String.valueOf(animal.getType()) + " Domestication ===");
        player.sendMessage("\u00a7eDomestication Level: \u00a7f" + level + "/5");
        player.sendMessage("\u00a7eDomestication Factor: \u00a7f" + String.format("%.1f%%", factor * 100.0));
        player.sendMessage("\u00a7eStatus: \u00a7f" + (fullyDomesticated ? "\u00a7aFully Domesticated" : "\u00a7cWild/Partial"));
        player.sendMessage("\u00a7eAggressive: \u00a7f" + (isAggressive ? "\u00a7cYes" : "\u00a7aNo"));
    }

    @Subcommand(value="set")
    @CommandPermission(value="atom.domestication.set")
    public void setDomestication(Player player, int level) {
        if (level < 0 || level > 5) {
            player.sendMessage("\u00a7cLevel must be between 0 and 5!");
            return;
        }
        RayTraceResult result = player.rayTraceEntities(5);
        if (result == null || result.getHitEntity() == null) {
            player.sendMessage("\u00a7cNo animal found. Look at an animal within 5 blocks.");
            return;
        }
        Entity entity = result.getHitEntity();
        if (!(entity instanceof Animals)) {
            player.sendMessage("\u00a7cThat's not an animal!");
            return;
        }
        Animals animal = (Animals)entity;
        animal.setMetadata("domesticationLevel", (MetadataValue)new FixedMetadataValue((Plugin)Atom.getInstance(), (Object)level));
        if (level >= 5) {
            animal.setMetadata("fullyDomesticated", (MetadataValue)new FixedMetadataValue((Plugin)Atom.getInstance(), (Object)true));
        } else {
            animal.removeMetadata("fullyDomesticated", (Plugin)Atom.getInstance());
        }
        player.sendMessage("\u00a7aSet " + String.valueOf(animal.getType()) + " domestication level to " + level);
        player.sendMessage("\u00a7eRespawn the animal to see stat changes take effect.");
    }
}

