/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.combat;

import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Mob;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class FatigueSystem {
    private final Plugin plugin;
    private static final int FATIGUE_THRESHOLD = 100;
    private static final double STAMINA_DRAIN_COMBAT = 0.9;
    private static final double FATIGUE_DAMAGE_MULTIPLIER = 0.6;
    private static final double FATIGUE_ATTACK_SPEED_MULTIPLIER = 0.7;

    public FatigueSystem(Plugin plugin) {
        this.plugin = plugin;
    }

    public void trackCombat(Mob mob) {
        if (!mob.hasMetadata("combat_ticks")) {
            mob.setMetadata("combat_ticks", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)0));
        }
        int combatTicks = ((MetadataValue)mob.getMetadata("combat_ticks").get(0)).asInt();
        mob.setMetadata("combat_ticks", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)(++combatTicks)));
        this.drainStamina(mob);
        if (combatTicks >= 100) {
            mob.setMetadata("fatigued", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
        }
    }

    public void resetCombat(Mob mob) {
        mob.removeMetadata("combat_ticks", this.plugin);
        if (!mob.hasMetadata("fatigue_recovery_timer")) {
            mob.setMetadata("fatigue_recovery_timer", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)0));
        }
        int recoveryTimer = ((MetadataValue)mob.getMetadata("fatigue_recovery_timer").get(0)).asInt();
        if (++recoveryTimer >= 200) {
            mob.removeMetadata("fatigued", this.plugin);
            mob.removeMetadata("fatigue_recovery_timer", this.plugin);
        } else {
            mob.setMetadata("fatigue_recovery_timer", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)recoveryTimer));
        }
    }

    public boolean isFatigued(Mob mob) {
        return mob.hasMetadata("fatigued") && ((MetadataValue)mob.getMetadata("fatigued").get(0)).asBoolean();
    }

    public void applyFatigueDebuff(Mob mob) {
        if (!this.isFatigued(mob)) {
            return;
        }
        mob.setMetadata("fatigue_damage_multiplier", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)0.6));
        mob.setMetadata("fatigue_attack_speed_multiplier", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)0.7));
        if (mob.getTicksLived() % 40 == 0) {
            this.spawnFatigueParticles(mob);
        }
    }

    public double getDamageMultiplier(Mob mob) {
        if (this.isFatigued(mob) && mob.hasMetadata("fatigue_damage_multiplier")) {
            return ((MetadataValue)mob.getMetadata("fatigue_damage_multiplier").get(0)).asDouble();
        }
        return 1.0;
    }

    public double getAttackSpeedMultiplier(Mob mob) {
        if (this.isFatigued(mob) && mob.hasMetadata("fatigue_attack_speed_multiplier")) {
            return ((MetadataValue)mob.getMetadata("fatigue_attack_speed_multiplier").get(0)).asDouble();
        }
        return 1.0;
    }

    private void drainStamina(Mob mob) {
        if (!mob.hasMetadata("stamina")) {
            double maxStamina = 100.0 + Math.random() * 100.0;
            mob.setMetadata("maxStamina", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)maxStamina));
            mob.setMetadata("stamina", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)maxStamina));
            return;
        }
        double stamina = ((MetadataValue)mob.getMetadata("stamina").get(0)).asDouble();
        stamina = Math.max(0.0, stamina - 0.9);
        mob.setMetadata("stamina", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)stamina));
        if (stamina <= 0.0) {
            mob.setMetadata("fatigued", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
        }
    }

    private void spawnFatigueParticles(Mob mob) {
        Location loc = mob.getLocation();
        if (loc.getWorld() == null) {
            return;
        }
        loc.getWorld().spawnParticle(Particle.SWEEP_ATTACK, loc.clone().add(0.0, 1.0, 0.0), 3, 0.3, 0.3, 0.3, 0.0);
    }
}

