/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.combat;

import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Mob;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class InjurySystem {
    private final Plugin plugin;
    private static final double WOUNDED_THRESHOLD = 0.7;
    private static final double CRITICAL_THRESHOLD = 0.3;
    private static final double WOUNDED_SPEED_MULTIPLIER = 0.7;
    private static final double CRITICAL_SPEED_MULTIPLIER = 0.5;

    public InjurySystem(Plugin plugin) {
        this.plugin = plugin;
    }

    public InjuryLevel getInjuryLevel(Mob mob) {
        if (!mob.isValid() || mob.isDead()) {
            return InjuryLevel.HEALTHY;
        }
        double maxHealth = mob.getAttribute(Attribute.MAX_HEALTH).getValue();
        double currentHealth = mob.getHealth();
        double healthPercent = currentHealth / maxHealth;
        if (healthPercent < 0.3) {
            return InjuryLevel.CRITICALLY_INJURED;
        }
        if (healthPercent < 0.7) {
            return InjuryLevel.WOUNDED;
        }
        return InjuryLevel.HEALTHY;
    }

    public void applyInjuryEffects(Mob mob) {
        InjuryLevel level = this.getInjuryLevel(mob);
        if (level == InjuryLevel.HEALTHY) {
            mob.removeMetadata("injury_level", this.plugin);
            mob.removeMetadata("injury_speed_multiplier", this.plugin);
            return;
        }
        mob.setMetadata("injury_level", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)level.name()));
        double speedMultiplier = switch (level.ordinal()) {
            case 1 -> 0.7;
            case 2 -> 0.5;
            default -> 1.0;
        };
        mob.setMetadata("injury_speed_multiplier", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)speedMultiplier));
        if (level == InjuryLevel.WOUNDED || level == InjuryLevel.CRITICALLY_INJURED) {
            this.applyLimpingEffect(mob, level);
        }
    }

    public void spawnBloodTrail(Mob mob) {
        int particleCount;
        InjuryLevel level = this.getInjuryLevel(mob);
        if (level == InjuryLevel.HEALTHY) {
            return;
        }
        Location loc = mob.getLocation();
        if (loc.getWorld() == null) {
            return;
        }
        switch (level.ordinal()) {
            case 1: {
                int n = 2;
                break;
            }
            case 2: {
                int n = 5;
                break;
            }
            default: {
                int n = particleCount = 0;
            }
        }
        if (particleCount > 0) {
            Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)139, (int)0, (int)0), 1.0f);
            loc.getWorld().spawnParticle(Particle.DUST, loc.clone().add(0.0, 0.2, 0.0), particleCount, 0.2, 0.1, 0.2, 0.0, (Object)dustOptions);
        }
    }

    public double getSpeedMultiplier(Mob mob) {
        if (mob.hasMetadata("injury_speed_multiplier")) {
            return ((MetadataValue)mob.getMetadata("injury_speed_multiplier").get(0)).asDouble();
        }
        return 1.0;
    }

    private void applyLimpingEffect(Mob mob, InjuryLevel level) {
        int limpInterval;
        if (!mob.hasMetadata("limp_timer")) {
            mob.setMetadata("limp_timer", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)0));
        }
        int timer = ((MetadataValue)mob.getMetadata("limp_timer").get(0)).asInt();
        int n = limpInterval = level == InjuryLevel.CRITICALLY_INJURED ? 10 : 20;
        if (++timer >= limpInterval) {
            timer = 0;
            if (mob.getVelocity().length() > 0.1) {
                Vector velocity = mob.getVelocity();
                velocity.multiply(0.3);
                mob.setVelocity(velocity);
            }
        }
        mob.setMetadata("limp_timer", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)timer));
    }

    public static enum InjuryLevel {
        HEALTHY,
        WOUNDED,
        CRITICALLY_INJURED;

    }
}

