/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.combat;

import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Mob;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.content.mobs.herd.Herd;
import org.shotrush.atom.content.mobs.herd.HerdManager;

public class MoraleSystem {
    private final Plugin plugin;
    private final HerdManager herdManager;
    private static final double MORALE_BREAK_THRESHOLD = 0.5;
    private static final double NEARBY_CHECK_RADIUS = 20.0;
    private static final int REGROUP_DURATION = 100;

    public MoraleSystem(Plugin plugin, HerdManager herdManager) {
        this.plugin = plugin;
        this.herdManager = herdManager;
    }

    public boolean checkMorale(Mob mob) {
        Optional<Herd> herdOpt = this.herdManager.getHerd(mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return true;
        }
        Herd herd = herdOpt.get();
        int totalMembers = 0;
        int deadOrFledMembers = 0;
        for (UUID memberId : herd.members()) {
            Mob member = (Mob)Bukkit.getEntity((UUID)memberId);
            if (member == null || !member.isValid() || member.isDead()) {
                ++deadOrFledMembers;
                ++totalMembers;
                continue;
            }
            if (member.getLocation().distance(mob.getLocation()) > 20.0) continue;
            ++totalMembers;
            if (!member.hasMetadata("fleeing") || !((MetadataValue)member.getMetadata("fleeing").get(0)).asBoolean()) continue;
            ++deadOrFledMembers;
        }
        if (totalMembers == 0) {
            return true;
        }
        double lossRatio = (double)deadOrFledMembers / (double)totalMembers;
        if (lossRatio > 0.5) {
            this.breakMorale(mob);
            return false;
        }
        return true;
    }

    public boolean isMoraleBroken(Mob mob) {
        if (!mob.hasMetadata("morale_broken")) {
            return false;
        }
        boolean broken = ((MetadataValue)mob.getMetadata("morale_broken").get(0)).asBoolean();
        if (broken) {
            int breakTimer;
            int n = breakTimer = mob.hasMetadata("morale_break_timer") ? ((MetadataValue)mob.getMetadata("morale_break_timer").get(0)).asInt() : 0;
            if (++breakTimer >= 100) {
                this.restoreMorale(mob);
                return false;
            }
            mob.setMetadata("morale_break_timer", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)breakTimer));
        }
        return broken;
    }

    public void breakMorale(Mob mob) {
        mob.setMetadata("morale_broken", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
        mob.setMetadata("morale_break_timer", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)0));
        mob.setMetadata("fleeing", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
        Optional<Herd> herdOpt = this.herdManager.getHerd(mob.getUniqueId());
        if (herdOpt.isPresent()) {
            Herd herd = herdOpt.get();
            for (UUID memberId : herd.members()) {
                Mob member = (Mob)Bukkit.getEntity((UUID)memberId);
                if (member == null || !member.isValid() || member.isDead() || !(member.getLocation().distance(mob.getLocation()) <= 20.0)) continue;
                member.setMetadata("morale_broken", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
                member.setMetadata("morale_break_timer", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)0));
                member.setMetadata("fleeing", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
            }
        }
    }

    private void restoreMorale(Mob mob) {
        mob.removeMetadata("morale_broken", this.plugin);
        mob.removeMetadata("morale_break_timer", this.plugin);
        Optional<Herd> herdOpt = this.herdManager.getHerd(mob.getUniqueId());
        if (herdOpt.isPresent()) {
            Herd herd = herdOpt.get();
            int nearbyAllies = 0;
            for (UUID memberId : herd.members()) {
                Mob member = (Mob)Bukkit.getEntity((UUID)memberId);
                if (member == null || !member.isValid() || member.isDead() || !(member.getLocation().distance(mob.getLocation()) <= 20.0)) continue;
                ++nearbyAllies;
            }
            if (nearbyAllies >= 2) {
                mob.removeMetadata("fleeing", this.plugin);
            }
        }
    }
}

