/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.config;

import java.util.EnumMap;
import java.util.Map;
import org.bukkit.entity.EntityType;

public record SpeciesBehavior(int minHerdSize, int maxHerdSize, double baseAggressionChance, double panicHealthThreshold, double fleeSpeedMultiplier, double chaseSpeedMultiplier, double cohesionRadiusMin, double cohesionRadiusMax, long panicDurationMs, double aggroRadius, SpecialMechanic specialMechanic) {
    private static final Map<EntityType, SpeciesBehavior> BEHAVIORS = new EnumMap<EntityType, SpeciesBehavior>(EntityType.class);

    public double getAggressionChance(double domesticationFactor) {
        return this.baseAggressionChance * (1.0 - domesticationFactor);
    }

    public double getFleeSpeed(double domesticationFactor) {
        double wildFactor = 1.0 - domesticationFactor;
        return 1.0 + (this.fleeSpeedMultiplier - 1.0) * wildFactor;
    }

    public double getChaseSpeed(double domesticationFactor) {
        double wildFactor = 1.0 - domesticationFactor;
        return 1.0 + (this.chaseSpeedMultiplier - 1.0) * wildFactor;
    }

    public double getCohesionRadius(double domesticationFactor) {
        return this.cohesionRadiusMin + (this.cohesionRadiusMax - this.cohesionRadiusMin) * (1.0 - domesticationFactor);
    }

    public int getHerdSize(double domesticationFactor) {
        double range = this.maxHerdSize - this.minHerdSize;
        return (int)((double)this.minHerdSize + range * (1.0 - domesticationFactor));
    }

    public static SpeciesBehavior get(EntityType type) {
        return BEHAVIORS.getOrDefault(type, SpeciesBehavior.createDefault());
    }

    private static SpeciesBehavior createDefault() {
        return new SpeciesBehavior(2, 8, 0.3, 0.5, 1.2, 1.1, 8.0, 12.0, 5000L, 10.0, SpecialMechanic.NONE);
    }

    static {
        BEHAVIORS.put(EntityType.COW, new SpeciesBehavior(2, 15, 0.05, 0.6, 1.5, 1.0, 6.0, 10.0, 6000L, 8.0, SpecialMechanic.STAMPEDE));
        BEHAVIORS.put(EntityType.PIG, new SpeciesBehavior(2, 8, 0.4, 0.5, 1.4, 1.3, 8.0, 12.0, 5000L, 10.0, SpecialMechanic.COUNTER_CHARGE));
        BEHAVIORS.put(EntityType.SHEEP, new SpeciesBehavior(4, 20, 0.15, 0.7, 1.2, 1.2, 4.0, 8.0, 7000L, 9.0, SpecialMechanic.RAM_CHARGE));
        BEHAVIORS.put(EntityType.CHICKEN, new SpeciesBehavior(2, 10, 0.2, 0.8, 1.3, 1.0, 6.0, 10.0, 4000L, 8.0, SpecialMechanic.FLIGHT_BURST));
        BEHAVIORS.put(EntityType.RABBIT, new SpeciesBehavior(2, 6, 0.05, 0.9, 1.6, 1.0, 12.0, 16.0, 5000L, 12.0, SpecialMechanic.ZIGZAG_FLEE));
        BEHAVIORS.put(EntityType.HORSE, new SpeciesBehavior(3, 12, 0.3, 0.5, 1.8, 1.5, 8.0, 14.0, 6000L, 12.0, SpecialMechanic.KICK_ATTACK));
        BEHAVIORS.put(EntityType.DONKEY, new SpeciesBehavior(2, 8, 0.5, 0.4, 1.3, 1.2, 8.0, 12.0, 7000L, 10.0, SpecialMechanic.BRAY_ALERT));
        BEHAVIORS.put(EntityType.MULE, new SpeciesBehavior(2, 8, 0.5, 0.4, 1.3, 1.2, 8.0, 12.0, 7000L, 10.0, SpecialMechanic.BRAY_ALERT));
        BEHAVIORS.put(EntityType.LLAMA, new SpeciesBehavior(4, 15, 0.6, 0.45, 1.3, 1.2, 8.0, 14.0, 6000L, 12.0, SpecialMechanic.SPIT_ATTACK));
        BEHAVIORS.put(EntityType.WOLF, new SpeciesBehavior(2, 8, 0.9, 0.2, 1.4, 1.6, 10.0, 16.0, 3000L, 16.0, SpecialMechanic.PACK_HUNTING));
        BEHAVIORS.put(EntityType.FOX, new SpeciesBehavior(2, 4, 0.4, 0.7, 1.5, 1.4, 10.0, 14.0, 5000L, 10.0, SpecialMechanic.POUNCE_ATTACK));
        BEHAVIORS.put(EntityType.CAT, new SpeciesBehavior(1, 2, 0.3, 0.8, 1.4, 1.2, 8.0, 12.0, 5000L, 8.0, SpecialMechanic.TREE_CLIMB));
        BEHAVIORS.put(EntityType.OCELOT, new SpeciesBehavior(1, 2, 0.3, 0.8, 1.4, 1.2, 8.0, 12.0, 5000L, 8.0, SpecialMechanic.TREE_CLIMB));
        BEHAVIORS.put(EntityType.POLAR_BEAR, new SpeciesBehavior(1, 2, 0.8, 0.15, 1.3, 1.4, 8.0, 12.0, 8000L, 14.0, SpecialMechanic.CUB_PROTECTION));
        BEHAVIORS.put(EntityType.PANDA, new SpeciesBehavior(2, 4, 0.5, 0.4, 1.2, 1.3, 8.0, 12.0, 6000L, 10.0, SpecialMechanic.NONE));
        BEHAVIORS.put(EntityType.GOAT, new SpeciesBehavior(4, 12, 0.5, 0.5, 1.2, 1.3, 8.0, 14.0, 6000L, 12.0, SpecialMechanic.RAM_CHARGE));
        BEHAVIORS.put(EntityType.CAMEL, new SpeciesBehavior(2, 8, 0.4, 0.35, 1.3, 1.2, 10.0, 16.0, 7000L, 12.0, SpecialMechanic.DASH_ABILITY));
        BEHAVIORS.put(EntityType.SNIFFER, new SpeciesBehavior(1, 2, 0.0, 0.5, 0.9, 0.9, 8.0, 12.0, 5000L, 8.0, SpecialMechanic.NONE));
        BEHAVIORS.put(EntityType.ARMADILLO, new SpeciesBehavior(1, 2, 0.0, 0.9, 1.1, 1.0, 6.0, 10.0, 4000L, 6.0, SpecialMechanic.ROLL_DEFENSE));
        BEHAVIORS.put(EntityType.TURTLE, new SpeciesBehavior(2, 4, 0.0, 0.6, 0.8, 0.8, 8.0, 12.0, 6000L, 8.0, SpecialMechanic.NONE));
        BEHAVIORS.put(EntityType.AXOLOTL, new SpeciesBehavior(1, 2, 0.6, 0.5, 1.1, 1.2, 6.0, 10.0, 4000L, 8.0, SpecialMechanic.NONE));
        BEHAVIORS.put(EntityType.FROG, new SpeciesBehavior(3, 6, 0.0, 0.7, 1.2, 1.0, 8.0, 12.0, 4000L, 6.0, SpecialMechanic.NONE));
        BEHAVIORS.put(EntityType.STRIDER, new SpeciesBehavior(1, 2, 0.0, 0.6, 1.0, 1.0, 8.0, 12.0, 5000L, 8.0, SpecialMechanic.NONE));
    }

    public static enum SpecialMechanic {
        NONE,
        STAMPEDE,
        COUNTER_CHARGE,
        RAM_CHARGE,
        FLIGHT_BURST,
        ZIGZAG_FLEE,
        BURROW_HIDE,
        KICK_ATTACK,
        BRAY_ALERT,
        SPIT_ATTACK,
        PACK_HUNTING,
        HOWL_CALL,
        POUNCE_ATTACK,
        TREE_CLIMB,
        CUB_PROTECTION,
        ROLL_DEFENSE,
        DASH_ABILITY;

    }
}

