/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.debug;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Description;
import co.aikar.commands.annotation.Subcommand;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.shotrush.atom.content.mobs.ai.debug.DebugCategory;
import org.shotrush.atom.content.mobs.ai.debug.DebugLevel;
import org.shotrush.atom.content.mobs.ai.debug.DebugManager;
import org.shotrush.atom.content.mobs.ai.debug.PerformanceMonitor;
import org.shotrush.atom.content.mobs.ai.debug.VisualDebugger;
import org.shotrush.atom.content.mobs.herd.Herd;
import org.shotrush.atom.content.mobs.herd.HerdManager;

@CommandAlias(value="mobai")
@Description(value="Debug commands for mob AI system")
@CommandPermission(value="atom.debug.mobai")
public class MobAIDebugCommand
extends BaseCommand {
    private final VisualDebugger visualDebugger;
    private final HerdManager herdManager;

    public MobAIDebugCommand(VisualDebugger visualDebugger, HerdManager herdManager) {
        this.visualDebugger = visualDebugger;
        this.herdManager = herdManager;
    }

    @Subcommand(value="debug")
    @Description(value="Set global debug level")
    @CommandCompletion(value="OFF|MINIMAL|NORMAL|VERBOSE")
    public void onDebugGlobal(Player player, String levelStr) {
        try {
            DebugLevel level = DebugLevel.valueOf(levelStr.toUpperCase());
            DebugManager.setGlobalLevel(level);
            player.sendMessage(Component.text("Global debug level set to: ", (TextColor)NamedTextColor.GREEN).append(Component.text(level.name(), (TextColor)NamedTextColor.YELLOW)));
        }
        catch (IllegalArgumentException e) {
            player.sendMessage((Component)Component.text("Invalid debug level. Use: OFF, MINIMAL, NORMAL, or VERBOSE", (TextColor)NamedTextColor.RED));
        }
    }

    @Subcommand(value="debug")
    @Description(value="Set category debug level")
    @CommandCompletion(value="GOALS|NEEDS|MEMORY|COMBAT|SOCIAL|ENVIRONMENTAL OFF|MINIMAL|NORMAL|VERBOSE")
    public void onDebugCategory(Player player, String categoryStr, String levelStr) {
        try {
            DebugCategory category = DebugCategory.valueOf(categoryStr.toUpperCase());
            DebugLevel level = DebugLevel.valueOf(levelStr.toUpperCase());
            DebugManager.setCategoryLevel(category, level);
            player.sendMessage(((TextComponent)((TextComponent)Component.text("Debug level for ", (TextColor)NamedTextColor.GREEN).append(Component.text(category.getDisplayName(), category.getColor()))).append(Component.text(" set to: ", (TextColor)NamedTextColor.GREEN))).append(Component.text(level.name(), (TextColor)NamedTextColor.YELLOW)));
        }
        catch (IllegalArgumentException e) {
            player.sendMessage((Component)Component.text("Invalid category or level.", (TextColor)NamedTextColor.RED));
        }
    }

    @Subcommand(value="info")
    @Description(value="Show detailed info about target entity")
    public void onInfo(Player player) {
        Entity target = player.getTargetEntity(10, false);
        if (!(target instanceof Mob)) {
            player.sendMessage((Component)Component.text("You must be looking at a mob!", (TextColor)NamedTextColor.RED));
            return;
        }
        Mob mob = (Mob)target;
        player.sendMessage((Component)Component.text("=== Mob AI Info ===", (TextColor)NamedTextColor.GOLD));
        player.sendMessage(Component.text("Type: ", (TextColor)NamedTextColor.GRAY).append(Component.text(mob.getType().name(), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage(Component.text("ID: ", (TextColor)NamedTextColor.GRAY).append(Component.text("#" + mob.getEntityId(), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage(Component.text("UUID: ", (TextColor)NamedTextColor.GRAY).append(Component.text(mob.getUniqueId().toString().substring(0, 8) + "...", (TextColor)NamedTextColor.DARK_GRAY)));
        player.sendMessage(Component.text("Health: ", (TextColor)NamedTextColor.GRAY).append(Component.text(String.format("%.1f / %.1f", mob.getHealth(), mob.getAttribute(Attribute.MAX_HEALTH).getValue()), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage(Component.text("Location: ", (TextColor)NamedTextColor.GRAY).append(Component.text(String.format("%.1f, %.1f, %.1f", mob.getLocation().getX(), mob.getLocation().getY(), mob.getLocation().getZ()), (TextColor)NamedTextColor.WHITE)));
        if (mob instanceof Animals) {
            Animals animal = (Animals)mob;
            this.displayHerdInfo(player, animal);
        }
    }

    @Subcommand(value="goals")
    @Description(value="List active goals for target entity")
    public void onGoals(Player player) {
        Entity target = player.getTargetEntity(10, false);
        if (!(target instanceof Mob)) {
            player.sendMessage((Component)Component.text("You must be looking at a mob!", (TextColor)NamedTextColor.RED));
            return;
        }
        Mob mob = (Mob)target;
        player.sendMessage((Component)Component.text("=== Active Goals ===", (TextColor)NamedTextColor.GOLD));
        player.sendMessage((Component)Component.text("Goal inspection requires server-side API access.", (TextColor)NamedTextColor.YELLOW));
        player.sendMessage((Component)Component.text("Enable VERBOSE debugging to see goal activations in real-time.", (TextColor)NamedTextColor.GRAY));
    }

    @Subcommand(value="herd")
    @Description(value="Show herd info and hierarchy")
    public void onHerd(Player player) {
        Entity target = player.getTargetEntity(10, false);
        if (!(target instanceof Animals)) {
            player.sendMessage((Component)Component.text("You must be looking at an animal!", (TextColor)NamedTextColor.RED));
            return;
        }
        Animals animal = (Animals)target;
        this.displayHerdInfo(player, animal);
    }

    private void displayHerdInfo(Player player, Animals animal) {
        Optional<Herd> herdOpt = this.herdManager.getHerd(animal.getUniqueId());
        if (herdOpt.isEmpty()) {
            player.sendMessage((Component)Component.text("This animal is not in a herd.", (TextColor)NamedTextColor.YELLOW));
            return;
        }
        Herd herd = herdOpt.get();
        boolean isLeader = herd.leader().equals(animal.getUniqueId());
        player.sendMessage((Component)Component.text("=== Herd Info ===", (TextColor)NamedTextColor.GOLD));
        player.sendMessage(Component.text("Herd Size: ", (TextColor)NamedTextColor.GRAY).append(Component.text(String.valueOf(herd.size()), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage(Component.text("Role: ", (TextColor)NamedTextColor.GRAY).append(Component.text(isLeader ? "LEADER" : "FOLLOWER", (TextColor)(isLeader ? NamedTextColor.YELLOW : NamedTextColor.AQUA))));
        player.sendMessage(Component.text("Panicking: ", (TextColor)NamedTextColor.GRAY).append(Component.text(herd.isPanicking() ? "Yes" : "No", (TextColor)(herd.isPanicking() ? NamedTextColor.RED : NamedTextColor.GREEN))));
        player.sendMessage(Component.text("Herd ID: ", (TextColor)NamedTextColor.GRAY).append(Component.text(herd.id().toString().substring(0, 8) + "...", (TextColor)NamedTextColor.DARK_GRAY)));
    }

    @Subcommand(value="track")
    @Description(value="Toggle visual tracking for target entity")
    public void onTrack(Player player) {
        Entity target = player.getTargetEntity(10, false);
        if (!(target instanceof Mob)) {
            player.sendMessage((Component)Component.text("You must be looking at a mob!", (TextColor)NamedTextColor.RED));
            return;
        }
        Mob mob = (Mob)target;
        this.visualDebugger.toggleTracking(mob.getUniqueId());
        this.visualDebugger.enableVisualsForPlayer(player.getUniqueId());
        boolean isTracking = this.visualDebugger.isTracking(mob.getUniqueId());
        player.sendMessage(Component.text(isTracking ? "Now tracking " : "Stopped tracking ", (TextColor)(isTracking ? NamedTextColor.GREEN : NamedTextColor.YELLOW)).append(Component.text(mob.getType().name() + " #" + mob.getEntityId(), (TextColor)NamedTextColor.WHITE)));
    }

    @Subcommand(value="performance")
    @Description(value="Show performance statistics")
    public void onPerformance(Player player) {
        PerformanceMonitor.displayStats(player);
    }

    @Subcommand(value="reset")
    @Description(value="Reset performance metrics")
    public void onReset(Player player) {
        PerformanceMonitor.reset();
        DebugManager.resetPerformanceMetrics();
        player.sendMessage((Component)Component.text("Performance metrics reset.", (TextColor)NamedTextColor.GREEN));
    }
}

