/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.shotrush.atom.content.mobs.ai.debug.DebugCategory;
import org.shotrush.atom.content.mobs.ai.debug.DebugLevel;
import org.shotrush.atom.content.mobs.ai.debug.DebugManager;

public class PerformanceMonitor {
    private static final Map<String, PerformanceStats> stats = new ConcurrentHashMap<String, PerformanceStats>();
    private static final int SAMPLE_SIZE = 100;

    public static void recordExecution(String operation, long nanos) {
        stats.computeIfAbsent(operation, PerformanceStats::new).addSample(nanos);
        double ms = (double)nanos / 1000000.0;
        if (ms > 5.0) {
            DebugManager.log(String.format("SLOW OPERATION: %s took %.2fms", operation, ms), DebugCategory.GOALS, DebugLevel.MINIMAL);
        }
    }

    public static long startTracking(String operation) {
        return System.nanoTime();
    }

    public static void endTracking(String operation, long startTime) {
        long duration = System.nanoTime() - startTime;
        PerformanceMonitor.recordExecution(operation, duration);
    }

    public static void displayStats(Player player) {
        if (stats.isEmpty()) {
            player.sendMessage((Component)Component.text("No performance data collected yet.", (TextColor)NamedTextColor.YELLOW));
            return;
        }
        player.sendMessage((Component)Component.text("=== MobAI Performance Stats ===", (TextColor)NamedTextColor.GOLD));
        player.sendMessage((Component)Component.text(""));
        ArrayList<PerformanceStats> sorted2 = new ArrayList<PerformanceStats>(stats.values());
        sorted2.sort((a, b) -> Double.compare(b.getRecentAverageMs(), a.getRecentAverageMs()));
        for (PerformanceStats stat : sorted2) {
            double avgMs = stat.getAverageMs();
            double recentAvgMs = stat.getRecentAverageMs();
            double minMs = stat.getMinMs();
            double maxMs = stat.getMaxMs();
            NamedTextColor color = recentAvgMs > 5.0 ? NamedTextColor.RED : (recentAvgMs > 2.0 ? NamedTextColor.YELLOW : NamedTextColor.GREEN);
            player.sendMessage((Component)Component.text(stat.operation, (TextColor)color));
            player.sendMessage((Component)Component.text(String.format("  Executions: %,d | Avg: %.2fms | Recent: %.2fms | Min: %.2fms | Max: %.2fms", stat.totalExecutions, avgMs, recentAvgMs, minMs, maxMs), (TextColor)NamedTextColor.GRAY));
        }
        player.sendMessage((Component)Component.text(""));
        player.sendMessage((Component)Component.text("Total tracked operations: " + stats.size(), (TextColor)NamedTextColor.GRAY));
    }

    public static void reset() {
        stats.clear();
    }

    public static Map<String, Double> getAverages() {
        HashMap<String, Double> averages = new HashMap<String, Double>();
        for (Map.Entry<String, PerformanceStats> entry : stats.entrySet()) {
            averages.put(entry.getKey(), entry.getValue().getRecentAverageMs());
        }
        return averages;
    }

    private static class PerformanceStats {
        final String operation;
        final Queue<Long> samples;
        long totalExecutions;
        long totalTime;
        long minTime;
        long maxTime;

        PerformanceStats(String operation) {
            this.operation = operation;
            this.samples = new LinkedList<Long>();
            this.totalExecutions = 0L;
            this.totalTime = 0L;
            this.minTime = Long.MAX_VALUE;
            this.maxTime = 0L;
        }

        synchronized void addSample(long nanos) {
            ++this.totalExecutions;
            this.totalTime += nanos;
            this.minTime = Math.min(this.minTime, nanos);
            this.maxTime = Math.max(this.maxTime, nanos);
            this.samples.add(nanos);
            if (this.samples.size() > 100) {
                this.samples.poll();
            }
        }

        synchronized double getAverageMs() {
            if (this.totalExecutions == 0L) {
                return 0.0;
            }
            return (double)this.totalTime / (double)this.totalExecutions / 1000000.0;
        }

        synchronized double getRecentAverageMs() {
            if (this.samples.isEmpty()) {
                return 0.0;
            }
            long sum = this.samples.stream().mapToLong(Long::longValue).sum();
            return (double)sum / (double)this.samples.size() / 1000000.0;
        }

        synchronized double getMinMs() {
            return this.minTime == Long.MAX_VALUE ? 0.0 : (double)this.minTime / 1000000.0;
        }

        synchronized double getMaxMs() {
            return (double)this.maxTime / 1000000.0;
        }
    }
}

