/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.debug;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.shotrush.atom.Atom;
import org.shotrush.atom.core.api.scheduler.SchedulerAPI;
import org.shotrush.atom.core.util.ActionBarManager;

public class VisualDebugger {
    private final Atom plugin;
    private final Map<UUID, TrackedMob> trackedMobs;
    private final Set<UUID> trackingPlayers;

    public VisualDebugger(Atom plugin) {
        this.plugin = plugin;
        this.trackedMobs = new ConcurrentHashMap<UUID, TrackedMob>();
        this.trackingPlayers = ConcurrentHashMap.newKeySet();
        this.startVisualUpdateTask();
    }

    public void trackMob(UUID mobId) {
        this.trackedMobs.computeIfAbsent(mobId, TrackedMob::new);
    }

    public void untrackMob(UUID mobId) {
        TrackedMob tracked = this.trackedMobs.remove(mobId);
        if (tracked != null && tracked.bossBar != null) {
            for (UUID playerId : this.trackingPlayers) {
                Player player = this.plugin.getServer().getPlayer(playerId);
                if (player == null) continue;
                player.hideBossBar(tracked.bossBar);
            }
        }
    }

    public boolean isTracking(UUID mobId) {
        return this.trackedMobs.containsKey(mobId);
    }

    public void toggleTracking(UUID mobId) {
        if (this.isTracking(mobId)) {
            this.untrackMob(mobId);
        } else {
            this.trackMob(mobId);
        }
    }

    public void enableVisualsForPlayer(UUID playerId) {
        this.trackingPlayers.add(playerId);
    }

    public void disableVisualsForPlayer(UUID playerId) {
        this.trackingPlayers.remove(playerId);
        Player player = this.plugin.getServer().getPlayer(playerId);
        if (player != null) {
            for (TrackedMob tracked : this.trackedMobs.values()) {
                if (tracked.bossBar == null) continue;
                player.hideBossBar(tracked.bossBar);
            }
        }
    }

    public void updateMobState(UUID mobId, String goalName, GoalState state) {
        TrackedMob tracked = this.trackedMobs.get(mobId);
        if (tracked == null) {
            return;
        }
        tracked.currentGoal = goalName;
        tracked.state = state;
    }

    public void updateMobNeeds(UUID mobId, double hunger, double thirst, double energy) {
        TrackedMob tracked = this.trackedMobs.get(mobId);
        if (tracked == null) {
            return;
        }
        tracked.hunger = hunger;
        tracked.thirst = thirst;
        tracked.energy = energy;
    }

    private void startVisualUpdateTask() {
        SchedulerAPI.runGlobalTaskTimer(() -> {
            for (TrackedMob tracked : this.trackedMobs.values()) {
                Mob mob = (Mob)this.plugin.getServer().getEntity(tracked.mobId);
                if (mob == null || !mob.isValid()) {
                    this.untrackMob(tracked.mobId);
                    continue;
                }
                this.updateVisuals(mob, tracked);
            }
        }, 5L, 5L);
    }

    private void updateVisuals(Mob mob, TrackedMob tracked) {
        Location loc = mob.getLocation().clone().add(0.0, mob.getHeight() + 0.5, 0.0);
        if (loc.getWorld() != null) {
            Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)tracked.state.getColor().getRed(), (int)tracked.state.getColor().getGreen(), (int)tracked.state.getColor().getBlue()), 1.0f);
            loc.getWorld().spawnParticle(Particle.DUST, loc, 3, 0.2, 0.2, 0.2, 0.0, (Object)dustOptions);
        }
        for (UUID playerId : this.trackingPlayers) {
            Player player = this.plugin.getServer().getPlayer(playerId);
            if (player == null || !(player.getLocation().distanceSquared(mob.getLocation()) < 1600.0)) continue;
            String color = tracked.state == GoalState.AGGRESSIVE ? "\u00a7c" : (tracked.state == GoalState.PEACEFUL ? "\u00a7a" : (tracked.state == GoalState.NEEDS_DRIVEN ? "\u00a79" : (tracked.state == GoalState.ENVIRONMENTAL ? "\u00a7e" : (tracked.state == GoalState.SOCIAL ? "\u00a7d" : "\u00a7f"))));
            ActionBarManager.send(player, color + mob.getType().name() + "#" + mob.getEntityId() + ": " + tracked.currentGoal);
            this.updateBossBar(player, tracked, mob);
        }
    }

    private void updateBossBar(Player player, TrackedMob tracked, Mob mob) {
        if (tracked.bossBar == null) {
            tracked.bossBar = BossBar.bossBar(Component.text(mob.getType().name() + " Needs"), 0.0f, BossBar.Color.GREEN, BossBar.Overlay.PROGRESS);
            player.showBossBar(tracked.bossBar);
        }
        double avgNeeds = (tracked.hunger + tracked.thirst + tracked.energy) / 3.0;
        float progress = Math.max(0.0f, Math.min(1.0f, (float)(avgNeeds / 100.0)));
        BossBar.Color barColor = avgNeeds < 25.0 ? BossBar.Color.RED : (avgNeeds < 50.0 ? BossBar.Color.YELLOW : BossBar.Color.GREEN);
        tracked.bossBar.progress(progress);
        tracked.bossBar.color(barColor);
        tracked.bossBar.name(Component.text(String.format("%s | H:%.0f%% T:%.0f%% E:%.0f%%", mob.getType().name(), tracked.hunger, tracked.thirst, tracked.energy), (TextColor)(barColor == BossBar.Color.RED ? NamedTextColor.RED : (barColor == BossBar.Color.YELLOW ? NamedTextColor.YELLOW : NamedTextColor.GREEN))));
    }

    public Set<UUID> getTrackedMobs() {
        return this.trackedMobs.keySet();
    }

    private static class TrackedMob {
        UUID mobId;
        String currentGoal;
        GoalState state;
        double hunger;
        double thirst;
        double energy;
        BossBar bossBar;

        TrackedMob(UUID mobId) {
            this.mobId = mobId;
            this.currentGoal = "Idle";
            this.state = GoalState.IDLE;
            this.hunger = 100.0;
            this.thirst = 100.0;
            this.energy = 100.0;
        }
    }

    public static enum GoalState {
        AGGRESSIVE(Color.RED, "Combat"),
        PEACEFUL(Color.GREEN, "Peaceful"),
        NEEDS_DRIVEN(Color.BLUE, "Needs"),
        ENVIRONMENTAL(Color.YELLOW, "Environmental"),
        SOCIAL(Color.fromRGB((int)170, (int)85, (int)255), "Social"),
        IDLE(Color.WHITE, "Idle");

        private final Color color;
        private final String displayName;

        private GoalState(Color color, String displayName) {
            this.color = color;
            this.displayName = displayName;
        }

        public Color getColor() {
            return this.color;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

