/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.content.mobs.ai.config.SpeciesBehavior;

public class AcquireNearestPlayerTargetGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final SpeciesBehavior behavior;
    private int scanTimer;
    private static final int SCAN_INTERVAL = 20;
    private static final double FIGHT_THRESHOLD = 0.3;

    public AcquireNearestPlayerTargetGoal(Mob mob, Plugin plugin, SpeciesBehavior behavior) {
        this.mob = mob;
        this.behavior = behavior;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "acquire_player_target"));
        this.scanTimer = 0;
    }

    public boolean shouldActivate() {
        if (!this.mob.hasMetadata("aggressive")) {
            return false;
        }
        if (!((MetadataValue)this.mob.getMetadata("aggressive").get(0)).asBoolean()) {
            return false;
        }
        double healthPercent = this.mob.getHealth() / this.mob.getAttribute(Attribute.MAX_HEALTH).getValue();
        if (healthPercent < 0.3) {
            return false;
        }
        if (this.mob.hasMetadata("fleeing") && ((MetadataValue)this.mob.getMetadata("fleeing").get(0)).asBoolean()) {
            return false;
        }
        if (this.mob.getTarget() != null) {
            return false;
        }
        Player nearest = this.findNearestPlayer();
        if (nearest != null) {
            this.mob.setTarget((LivingEntity)nearest);
            return true;
        }
        return false;
    }

    public boolean shouldStayActive() {
        if (this.mob.getTarget() == null) {
            return false;
        }
        double healthPercent = this.mob.getHealth() / this.mob.getAttribute(Attribute.MAX_HEALTH).getValue();
        if (healthPercent < 0.3) {
            this.mob.setTarget(null);
            return false;
        }
        if (this.mob.hasMetadata("fleeing") && ((MetadataValue)this.mob.getMetadata("fleeing").get(0)).asBoolean()) {
            this.mob.setTarget(null);
            return false;
        }
        return this.mob.getTarget().isValid() && this.mob.getLocation().distance(this.mob.getTarget().getLocation()) < this.behavior.aggroRadius() * 2.0;
    }

    public void start() {
        this.scanTimer = 0;
    }

    public void stop() {
        this.mob.setTarget(null);
    }

    public void tick() {
        ++this.scanTimer;
        if (this.scanTimer >= 20) {
            this.scanTimer = 0;
            Player nearest = this.findNearestPlayer();
            if (nearest != null && (this.mob.getTarget() == null || this.mob.getLocation().distance(nearest.getLocation()) < this.mob.getLocation().distance(this.mob.getTarget().getLocation()))) {
                this.mob.setTarget((LivingEntity)nearest);
            }
        }
    }

    private Player findNearestPlayer() {
        Player nearest = null;
        double nearestDist = this.behavior.aggroRadius();
        for (Player player : this.mob.getLocation().getNearbyPlayers(this.behavior.aggroRadius())) {
            double dist;
            if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR || !((dist = player.getLocation().distance(this.mob.getLocation())) < nearestDist)) continue;
            nearest = player;
            nearestDist = dist;
        }
        return nearest;
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.TARGET);
    }
}

