/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.shotrush.atom.content.mobs.AnimalDomestication;
import org.shotrush.atom.content.mobs.ai.config.SpeciesBehavior;

public class AvoidPlayerWhenInjuredGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final SpeciesBehavior behavior;
    private Player nearestPlayer;
    private int scanTimer;
    private static final int SCAN_INTERVAL = 10;
    private static final double FLEE_DISTANCE = 10.0;

    public AvoidPlayerWhenInjuredGoal(Mob mob, Plugin plugin, SpeciesBehavior behavior) {
        this.mob = mob;
        this.behavior = behavior;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "avoid_player_injured"));
        this.scanTimer = 0;
    }

    public boolean shouldActivate() {
        double healthPercent = this.mob.getHealth() / this.mob.getAttribute(Attribute.MAX_HEALTH).getValue();
        if (healthPercent >= this.behavior.panicHealthThreshold()) {
            return false;
        }
        if (this.mob.hasMetadata("aggressive") && ((MetadataValue)this.mob.getMetadata("aggressive").get(0)).asBoolean()) {
            return false;
        }
        this.nearestPlayer = this.findNearestPlayer();
        return this.nearestPlayer != null;
    }

    public boolean shouldStayActive() {
        double healthPercent = this.mob.getHealth() / this.mob.getAttribute(Attribute.MAX_HEALTH).getValue();
        if (healthPercent >= this.behavior.panicHealthThreshold() * 1.2) {
            return false;
        }
        if (this.nearestPlayer == null || !this.nearestPlayer.isValid()) {
            return false;
        }
        return this.mob.getLocation().distance(this.nearestPlayer.getLocation()) < 20.0;
    }

    public void start() {
        this.mob.setTarget(null);
        this.scanTimer = 0;
    }

    public void stop() {
        this.nearestPlayer = null;
    }

    public void tick() {
        ++this.scanTimer;
        if (this.scanTimer >= 10) {
            this.scanTimer = 0;
            this.nearestPlayer = this.findNearestPlayer();
        }
        if (this.nearestPlayer == null || !this.nearestPlayer.isValid()) {
            return;
        }
        Location current = this.mob.getLocation();
        if (current == null || current.getWorld() == null) {
            return;
        }
        Location playerLoc = this.nearestPlayer.getLocation();
        if (playerLoc == null) {
            return;
        }
        Vector awayFromPlayer = current.toVector().subtract(playerLoc.toVector()).normalize();
        Location fleeTarget = current.clone().add(awayFromPlayer.multiply(15.0));
        if (fleeTarget == null || fleeTarget.getWorld() == null) {
            return;
        }
        double domesticationFactor = AnimalDomestication.getDomesticationFactor((Animals)this.mob);
        double speed = this.behavior.getFleeSpeed(domesticationFactor) * 0.8;
        this.mob.getPathfinder().moveTo(fleeTarget, speed);
    }

    private Player findNearestPlayer() {
        Player nearest = null;
        double nearestDist = 10.0;
        for (Player player : this.mob.getLocation().getNearbyPlayers(10.0)) {
            double dist = player.getLocation().distance(this.mob.getLocation());
            if (!(dist < nearestDist)) continue;
            nearest = player;
            nearestDist = dist;
        }
        return nearest;
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE, GoalType.LOOK);
    }
}

