/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.content.mobs.AnimalDomestication;
import org.shotrush.atom.content.mobs.ai.combat.FatigueSystem;
import org.shotrush.atom.content.mobs.ai.combat.InjurySystem;
import org.shotrush.atom.content.mobs.ai.combat.MoraleSystem;
import org.shotrush.atom.content.mobs.ai.config.SpeciesBehavior;

public class ChaseAndMeleeAttackGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final SpeciesBehavior behavior;
    private final FatigueSystem fatigueSystem;
    private final InjurySystem injurySystem;
    private final MoraleSystem moraleSystem;
    private int attackCooldown;
    private static final int ATTACK_INTERVAL = 20;
    private static final double ATTACK_RANGE = 2.0;

    public ChaseAndMeleeAttackGoal(Mob mob, Plugin plugin, SpeciesBehavior behavior, FatigueSystem fatigueSystem, InjurySystem injurySystem, MoraleSystem moraleSystem) {
        this.mob = mob;
        this.behavior = behavior;
        this.fatigueSystem = fatigueSystem;
        this.injurySystem = injurySystem;
        this.moraleSystem = moraleSystem;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "chase_melee_attack"));
        this.attackCooldown = 0;
    }

    public boolean shouldActivate() {
        return this.mob.getTarget() != null && this.mob.getTarget().isValid();
    }

    public boolean shouldStayActive() {
        if (this.mob.getTarget() == null || !this.mob.getTarget().isValid()) {
            return false;
        }
        if (this.mob.hasMetadata("fleeing") && ((MetadataValue)this.mob.getMetadata("fleeing").get(0)).asBoolean()) {
            return false;
        }
        if (this.moraleSystem != null && this.moraleSystem.isMoraleBroken(this.mob)) {
            return false;
        }
        double distance = this.mob.getLocation().distance(this.mob.getTarget().getLocation());
        return distance < this.behavior.aggroRadius() * 2.5;
    }

    public void start() {
        this.attackCooldown = 0;
    }

    public void stop() {
    }

    public void tick() {
        double distance;
        LivingEntity target = this.mob.getTarget();
        if (target == null || !target.isValid()) {
            return;
        }
        Location current = this.mob.getLocation();
        if (current == null || current.getWorld() == null) {
            return;
        }
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return;
        }
        if (this.fatigueSystem != null) {
            this.fatigueSystem.trackCombat(this.mob);
            this.fatigueSystem.applyFatigueDebuff(this.mob);
        }
        if (this.injurySystem != null) {
            this.injurySystem.applyInjuryEffects(this.mob);
        }
        if (this.moraleSystem != null) {
            this.moraleSystem.checkMorale(this.mob);
        }
        if ((distance = current.distance(targetLoc)) > 2.0) {
            double domesticationFactor = AnimalDomestication.getDomesticationFactor((Animals)this.mob);
            double speed = this.behavior.getChaseSpeed(domesticationFactor);
            if (this.injurySystem != null) {
                speed *= this.injurySystem.getSpeedMultiplier(this.mob);
            }
            this.mob.getPathfinder().moveTo(targetLoc, speed);
        } else {
            this.mob.getPathfinder().stopPathfinding();
            int attackInterval = 20;
            if (this.fatigueSystem != null && this.fatigueSystem.isFatigued(this.mob)) {
                attackInterval = (int)(20.0 / this.fatigueSystem.getAttackSpeedMultiplier(this.mob));
            }
            if (this.attackCooldown <= 0) {
                this.performAttack(target);
                this.attackCooldown = attackInterval;
            }
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    private void performAttack(LivingEntity target) {
        this.mob.lookAt((Entity)target);
        try {
            this.mob.attack((Entity)target);
        }
        catch (IllegalArgumentException e) {
            double damage = 2.0;
            target.damage(damage, (Entity)this.mob);
        }
        this.mob.swingMainHand();
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE, GoalType.LOOK);
    }
}

