/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class CounterChargeGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private LivingEntity target;
    private int chargeCooldown;
    private boolean isCharging;
    private static final int COOLDOWN_TICKS = 120;
    private static final double HEALTH_THRESHOLD = 0.2;
    private static final double CHARGE_SPEED = 1.8;
    private static final double DAMAGE = 5.0;
    private static final double KNOCKBACK = 1.5;

    public CounterChargeGoal(Mob mob, Plugin plugin) {
        this.mob = mob;
        this.plugin = plugin;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "counter_charge"));
        this.chargeCooldown = 0;
        this.isCharging = false;
    }

    public boolean shouldActivate() {
        if (this.chargeCooldown > 0) {
            --this.chargeCooldown;
            return false;
        }
        double healthPercent = this.mob.getHealth() / this.mob.getAttribute(Attribute.MAX_HEALTH).getValue();
        if (healthPercent >= 0.2) {
            return false;
        }
        LivingEntity currentTarget = this.mob.getTarget();
        if (currentTarget == null || !currentTarget.isValid()) {
            return false;
        }
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            return false;
        }
        Location targetLoc = currentTarget.getLocation();
        if (targetLoc == null) {
            return false;
        }
        double distance = mobLoc.distance(targetLoc);
        if (distance >= 3.0 && distance <= 8.0) {
            this.target = currentTarget;
            return true;
        }
        return false;
    }

    public boolean shouldStayActive() {
        if (!this.isCharging) {
            return false;
        }
        if (this.target == null || !this.target.isValid()) {
            return false;
        }
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null) {
            return false;
        }
        Location targetLoc = this.target.getLocation();
        if (targetLoc == null) {
            return false;
        }
        double distance = mobLoc.distance(targetLoc);
        return distance > 1.5;
    }

    public void start() {
        this.isCharging = true;
        Location mobLoc = this.mob.getLocation();
        if (mobLoc != null && mobLoc.getWorld() != null) {
            mobLoc.getWorld().playSound(mobLoc, Sound.ENTITY_RAVAGER_STUNNED, 0.7f, 1.8f);
            mobLoc.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, mobLoc.clone().add(0.0, 1.0, 0.0), 3);
        }
    }

    public void stop() {
        this.isCharging = false;
        this.target = null;
        this.chargeCooldown = 120;
    }

    public void tick() {
        if (this.target == null || !this.target.isValid()) {
            this.stop();
            return;
        }
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            this.stop();
            return;
        }
        Location targetLoc = this.target.getLocation();
        if (targetLoc == null) {
            this.stop();
            return;
        }
        double distance = mobLoc.distance(targetLoc);
        if (distance < 2.0) {
            this.performHit();
            this.stop();
            return;
        }
        this.mob.getPathfinder().moveTo(targetLoc, 1.8);
    }

    private void performHit() {
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            return;
        }
        if (this.target == null) {
            return;
        }
        this.target.damage(5.0, (Entity)this.mob);
        Vector knockbackDirection = this.target.getLocation().toVector().subtract(mobLoc.toVector()).normalize();
        knockbackDirection.setY(0.15);
        this.target.setVelocity(knockbackDirection.multiply(1.5));
        mobLoc.getWorld().playSound(mobLoc, Sound.ENTITY_HOGLIN_ATTACK, 1.0f, 1.2f);
        mobLoc.getWorld().spawnParticle(Particle.CRIT, this.target.getLocation(), 15, 0.3, 0.5, 0.3, 0.1);
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE, GoalType.LOOK);
    }
}

