/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.PolarBear;
import org.bukkit.plugin.Plugin;

public class CubProtectionGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private boolean enraged;
    private static final double CUB_PROTECTION_RADIUS = 10.0;
    private static final double ENRAGE_DAMAGE_BONUS = 4.0;
    private static final NamespacedKey ENRAGE_KEY = new NamespacedKey("atom", "cub_protection_enrage");

    public CubProtectionGoal(Mob mob, Plugin plugin) {
        this.mob = mob;
        this.plugin = plugin;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "cub_protection"));
        this.enraged = false;
    }

    public boolean shouldActivate() {
        Mob mob = this.mob;
        if (!(mob instanceof PolarBear)) {
            return false;
        }
        PolarBear bear = (PolarBear)mob;
        Location bearLoc = this.mob.getLocation();
        if (bearLoc == null || bearLoc.getWorld() == null) {
            return false;
        }
        for (Entity nearby : bearLoc.getWorld().getNearbyEntities(bearLoc, 10.0, 10.0, 10.0)) {
            Entity entity;
            PolarBear cub;
            if (!(nearby instanceof PolarBear) || (cub = (PolarBear)nearby).isAdult() || cub.getUniqueId() == this.mob.getUniqueId() || cub.getLastDamageCause() == null || !((entity = cub.getLastDamageCause().getEntity()) instanceof LivingEntity)) continue;
            LivingEntity attacker = (LivingEntity)entity;
            this.mob.setTarget(attacker);
            return true;
        }
        return false;
    }

    public boolean shouldStayActive() {
        return this.enraged && this.mob.getTarget() != null && this.mob.getTarget().isValid();
    }

    public void start() {
        this.enraged = true;
        this.applyEnrageBonus();
        Location mobLoc = this.mob.getLocation();
        if (mobLoc != null && mobLoc.getWorld() != null) {
            mobLoc.getWorld().playSound(mobLoc, Sound.ENTITY_POLAR_BEAR_WARNING, 2.0f, 0.8f);
            mobLoc.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, mobLoc.clone().add(0.0, 2.0, 0.0), 5, 0.5, 0.5, 0.5);
        }
    }

    public void stop() {
        this.enraged = false;
        this.removeEnrageBonus();
    }

    public void tick() {
        Location mobLoc = this.mob.getLocation();
        if (mobLoc != null && mobLoc.getWorld() != null && Math.random() < 0.05) {
            mobLoc.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, mobLoc.clone().add(0.0, 2.0, 0.0), 1);
        }
    }

    private void applyEnrageBonus() {
        AttributeInstance attackDamage = this.mob.getAttribute(Attribute.ATTACK_DAMAGE);
        if (attackDamage == null) {
            return;
        }
        AttributeModifier modifier = new AttributeModifier(ENRAGE_KEY, 4.0, AttributeModifier.Operation.ADD_NUMBER);
        attackDamage.addModifier(modifier);
    }

    private void removeEnrageBonus() {
        AttributeInstance attackDamage = this.mob.getAttribute(Attribute.ATTACK_DAMAGE);
        if (attackDamage == null) {
            return;
        }
        attackDamage.getModifiers().stream().filter(mod -> mod.getKey().equals((Object)ENRAGE_KEY)).forEach(arg_0 -> ((AttributeInstance)attackDamage).removeModifier(arg_0));
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.TARGET);
    }
}

