/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Animals;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.content.mobs.ai.combat.MoraleSystem;
import org.shotrush.atom.content.mobs.herd.Herd;
import org.shotrush.atom.content.mobs.herd.HerdManager;

public class DeathEffectsGoal
implements Goal<Mob>,
Listener {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private final HerdManager herdManager;
    private final MoraleSystem moraleSystem;
    private Location corpseLocation;
    private int mourningTicks;
    private boolean wasAttackDeath;
    private static final int MOURNING_DURATION = 200;
    private static final double GATHERING_RADIUS = 30.0;
    private static final double MOURN_DISTANCE = 3.0;

    public DeathEffectsGoal(Mob mob, Plugin plugin, HerdManager herdManager, MoraleSystem moraleSystem) {
        this.mob = mob;
        this.plugin = plugin;
        this.herdManager = herdManager;
        this.moraleSystem = moraleSystem;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "death_effects"));
        this.mourningTicks = 0;
        this.wasAttackDeath = false;
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity deceased = event.getEntity();
        if (!(deceased instanceof Animals)) {
            return;
        }
        Optional<Herd> deceasedHerdOpt = this.herdManager.getHerd(deceased.getUniqueId());
        if (deceasedHerdOpt.isEmpty()) {
            return;
        }
        Optional<Herd> mobHerdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (mobHerdOpt.isEmpty()) {
            return;
        }
        if (!deceasedHerdOpt.get().equals(mobHerdOpt.get())) {
            return;
        }
        Location deathLoc = deceased.getLocation();
        if (deathLoc == null) {
            return;
        }
        double distance = this.mob.getLocation().distance(deathLoc);
        if (distance > 30.0) {
            return;
        }
        this.corpseLocation = deathLoc.clone();
        this.mourningTicks = 0;
        this.wasAttackDeath = deceased.getLastDamageCause() != null && deceased.getKiller() != null;
        this.moraleSystem.breakMorale(this.mob);
    }

    public boolean shouldActivate() {
        return this.corpseLocation != null && this.mourningTicks < 200;
    }

    public boolean shouldStayActive() {
        if (this.corpseLocation == null) {
            return false;
        }
        if (this.mourningTicks >= 200) {
            return false;
        }
        Location mobLoc = this.mob.getLocation();
        return mobLoc != null && mobLoc.getWorld() != null;
    }

    public void start() {
        this.mob.getPathfinder().stopPathfinding();
    }

    public void stop() {
        Location mobLoc;
        if (this.wasAttackDeath && this.corpseLocation != null && (mobLoc = this.mob.getLocation()) != null && this.corpseLocation.getWorld() != null) {
            Location fleeTarget = mobLoc.clone().subtract(this.corpseLocation.toVector().subtract(mobLoc.toVector()).normalize().multiply(20));
            this.mob.getPathfinder().moveTo(fleeTarget, 1.5);
        }
        this.corpseLocation = null;
        this.mourningTicks = 0;
        this.wasAttackDeath = false;
    }

    public void tick() {
        if (this.corpseLocation == null) {
            this.stop();
            return;
        }
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            this.stop();
            return;
        }
        ++this.mourningTicks;
        double distance = mobLoc.distance(this.corpseLocation);
        if (distance > 3.0) {
            this.mob.getPathfinder().moveTo(this.corpseLocation, 0.8);
        } else {
            Mob mob;
            this.mob.getPathfinder().stopPathfinding();
            if (this.mourningTicks % 40 == 0) {
                this.playMourningSounds(mobLoc);
            }
            if (this.mourningTicks % 20 == 0) {
                this.spawnMourningParticles(this.corpseLocation);
            }
            if ((mob = this.mob) instanceof Animals) {
                Animals animal = (Animals)mob;
                if (this.mourningTicks % 60 == 0) {
                    this.mob.lookAt(this.corpseLocation);
                }
            }
        }
    }

    private void playMourningSounds(Location mobLoc) {
        if (mobLoc.getWorld() == null) {
            return;
        }
        Sound sound = switch (this.mob.getType()) {
            case EntityType.COW -> Sound.ENTITY_COW_AMBIENT;
            case EntityType.SHEEP -> Sound.ENTITY_SHEEP_AMBIENT;
            case EntityType.PIG -> Sound.ENTITY_PIG_AMBIENT;
            case EntityType.WOLF -> Sound.ENTITY_WOLF_WHINE;
            case EntityType.HORSE -> Sound.ENTITY_HORSE_BREATHE;
            case EntityType.CHICKEN -> Sound.ENTITY_CHICKEN_AMBIENT;
            case EntityType.RABBIT -> Sound.ENTITY_RABBIT_AMBIENT;
            case EntityType.LLAMA -> Sound.ENTITY_LLAMA_AMBIENT;
            default -> Sound.ENTITY_GENERIC_HURT;
        };
        mobLoc.getWorld().playSound(mobLoc, sound, 0.4f, 0.6f);
    }

    private void spawnMourningParticles(Location loc) {
        if (loc.getWorld() == null) {
            return;
        }
        loc.getWorld().spawnParticle(Particle.SOUL, loc.clone().add(0.0, 0.5, 0.0), 2, 0.3, 0.3, 0.3, 0.01);
        loc.getWorld().spawnParticle(Particle.ASH, loc.clone().add(0.0, 0.1, 0.0), 3, 0.2, 0.1, 0.2, 0.0);
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE, GoalType.LOOK, GoalType.TARGET);
    }
}

